/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.tiger.IFinalizer;
import org.polarsys.capella.core.tiger.IResolver;
import org.polarsys.capella.core.tiger.ITracelinkProvider;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRule;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.impl.TransfoRule;
import org.polarsys.capella.core.tiger.impl.TransfoRuleBase;
import org.polarsys.capella.core.tiger.impl.TransfoRuleLoader;

public class Transfo
extends HashMap<String, Object>
implements ITransfo {
    private static String __cr = System.getProperty("line.separator");
    private static final String RULE_NAME_ID = "rulename";
    private static final long serialVersionUID = -4143258412471058338L;
    private static final String TRANSFO_LINK_ID = "transfolink";
    private EClass _eDefaultTrace;
    private HashMap<String, EClass> _eSpecificLinkKindMap;
    private List<IFinalizer> _finalizers = new ArrayList<IFinalizer>(1);
    private List<IResolver> _resolvers = new ArrayList<IResolver>(1);
    private ITransfoRuleBase _ruleBase;
    private Map<EObject, ITransfoRule> _ruleBaseCache;
    private String _uid = "noUID";

    public Transfo() {
        this._ruleBase = new TransfoRuleBase();
        this._ruleBaseCache = new HashMap<EObject, ITransfoRule>();
        this._eSpecificLinkKindMap = new HashMap();
        this.loadRulesFromExtensionPoint(null);
    }

    public Transfo(EClass eGenericTrace) {
        this();
        this._eDefaultTrace = eGenericTrace;
    }

    public Transfo(EClass eGenericTrace, String context) {
        this._eDefaultTrace = eGenericTrace;
        this._ruleBase = new TransfoRuleBase();
        this._ruleBaseCache = new HashMap<EObject, ITransfoRule>();
        this._eSpecificLinkKindMap = new HashMap();
        this.loadRulesFromExtensionPoint(context);
    }

    public Transfo(ITransfoRuleBase ruleBase) {
        this._ruleBase = ruleBase;
        this._ruleBaseCache = new HashMap<EObject, ITransfoRule>();
        this._eSpecificLinkKindMap = new HashMap();
    }

    public Transfo(ITransfoRuleBase ruleBase, EClass eGenericTrace) {
        this(ruleBase);
        this._eDefaultTrace = eGenericTrace;
    }

    public Transfo(ITransfoRuleBase ruleBase, EClass eGenericTrace, String context) {
        this(ruleBase, eGenericTrace);
        this.loadRulesFromExtensionPoint(context);
    }

    public Transfo(String context) {
        this._ruleBase = new TransfoRuleBase();
        this._ruleBaseCache = new HashMap<EObject, ITransfoRule>();
        this._eSpecificLinkKindMap = new HashMap();
        this.loadRulesFromExtensionPoint(context);
    }

    public void addResolver(IResolver resolver) {
        this._resolvers.add(resolver);
    }

    @Override
    public void addRule(TransfoRule rule) {
        this._ruleBase.addRule(rule);
    }

    @Override
    public ITransfoRule findCachedMatchingRule(EObject element) throws TransfoException {
        ITransfoRule rule = this._ruleBaseCache.get(element);
        if (rule == null) {
            rule = this._ruleBase.findMatchingRule(element, this);
            this._ruleBaseCache.put(element, rule);
        }
        if (rule == null) {
            throw new TransfoException("rule not found", element);
        }
        this.setSpecificLinkKindFromMap(rule.getSourceType(), rule.getTargetType(), rule.getSpecificLinkKind());
        return rule;
    }

    @Override
    public ITransfoRule findMatchingRule(EObject element) throws TransfoException {
        return this._ruleBase.findMatchingRule(element, this);
    }

    public EClass get_eDefaultTrace() {
        return this._eDefaultTrace;
    }

    @Override
    public List<IFinalizer> getFinalizers() {
        return this._finalizers;
    }

    private String getKey(EClass sourceType, EClass targetType) {
        return String.valueOf(sourceType.getName()) + "_" + targetType.getName();
    }

    @Override
    public List<IResolver> getResolvers() {
        return this._resolvers;
    }

    public EClass getSpecificLinkKindFromMap(EObject srcEltType, EObject tgtEltType) {
        String sourceKey = this.getKey(srcEltType.eClass(), tgtEltType.eClass());
        EClass specific = this._eSpecificLinkKindMap.get(sourceKey);
        if (specific == null) {
            ArrayList<EClass> superSources = new ArrayList<EClass>((Collection<EClass>)srcEltType.eClass().getEAllSuperTypes());
            superSources.add(srcEltType.eClass());
            ArrayList<EClass> superTargets = new ArrayList<EClass>((Collection<EClass>)tgtEltType.eClass().getEAllSuperTypes());
            superTargets.add(tgtEltType.eClass());
            for (EClass eclassSource : superSources) {
                for (EClass eclassTarget : superTargets) {
                    specific = this._eSpecificLinkKindMap.get(this.getKey(eclassSource, eclassTarget));
                    if (specific == null) continue;
                    this._eSpecificLinkKindMap.put(sourceKey, specific);
                    return specific;
                }
            }
        }
        return specific;
    }

    @Override
    public String getUid() {
        return this._uid;
    }

    public boolean isValidLinkKind(AbstractTrace link) {
        EClass eGenericTraceFound = null;
        TraceableElement sourceType = link.getTargetElement();
        TraceableElement targetType = link.getSourceElement();
        if (sourceType != null && targetType != null && (eGenericTraceFound = this.getSpecificLinkKindFromMap((EObject)sourceType, (EObject)targetType)) == null && this.get_eDefaultTrace() != null) {
            eGenericTraceFound = this.get_eDefaultTrace();
        }
        return eGenericTraceFound != null && EcoreUtil2.isEqualOrSuperClass(eGenericTraceFound, (EClass)link.eClass());
    }

    void loadFinalizer(Bundle bundle, String finalizer) {
        try {
            Class clazz = bundle.loadClass(finalizer);
            IFinalizer finalizerInstance = (IFinalizer)clazz.newInstance();
            this._finalizers.add(finalizerInstance);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    void loadRule(Bundle bundle, String packageName, IConfigurationElement ruleElement) {
        String ruleName = ruleElement.getAttribute(RULE_NAME_ID);
        String linkName = ruleElement.getAttribute(TRANSFO_LINK_ID);
        String completeName = String.valueOf(packageName) + "." + ruleName;
        try {
            Class clazz = bundle.loadClass(completeName);
            TransfoRule ruleInstance = (TransfoRule)clazz.newInstance();
            this.addRule(ruleInstance);
            if (linkName != null && !linkName.equals("")) {
                this.setSpecificLinkKindFromMap(ruleInstance.getSourceType(), ruleInstance.getTargetType(), this.loadTrace(bundle, linkName));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadRule(Class<?> ruleClass) {
        this._ruleBase.loadRule(ruleClass);
    }

    @Override
    public void loadRules(String rulePkgName) throws ClassNotFoundException {
        this._ruleBase.loadRules(rulePkgName);
    }

    @Override
    public void loadRules(String rulePkgName, String[] classNames) throws ClassNotFoundException {
        this._ruleBase.loadRules(rulePkgName, classNames);
    }

    void loadRulesFromExtensionPoint(String contextName) {
        TransfoRuleLoader loader = new TransfoRuleLoader(this);
        loader.loadContext(contextName);
        EClass defaultTrace = loader.getDefaultTrace();
        if (defaultTrace != null && this._eDefaultTrace != defaultTrace) {
            this._eDefaultTrace = defaultTrace;
        }
    }

    EClass loadTrace(Bundle bundle, String transfoLinkName) {
        EClass result = this._eDefaultTrace;
        try {
            Class clazz = bundle.loadClass(transfoLinkName);
            ITracelinkProvider ruleInstance = (ITracelinkProvider)clazz.newInstance();
            result = ruleInstance.getTraceLinkType();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void setSpecificLinkKindFromMap(EClass sourceType, EClass targetType, EClass traceType) {
        if (sourceType != null && targetType != null && traceType != null) {
            String key = this.getKey(sourceType, targetType);
            this._eSpecificLinkKindMap.put(key, traceType);
        }
    }

    @Override
    public void setUid(String uid) {
        this._uid = uid;
    }

    @Override
    public String toHtml() {
        StringBuilder htmlDoc = new StringBuilder();
        htmlDoc.append("<html>").append(__cr);
        htmlDoc.append("<head>").append(__cr);
        htmlDoc.append("<title> Rule Base Documentation </title>" + __cr);
        htmlDoc.append("</head>").append(__cr);
        htmlDoc.append("<body>").append(__cr);
        htmlDoc.append(this._ruleBase.toHtml(false));
        htmlDoc.append("</body>").append(__cr);
        htmlDoc.append("</html>").append(__cr);
        return htmlDoc.toString();
    }

    @Override
    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Transformation <");
        builder.append(this._uid);
        builder.append(">");
        builder.append(newLine);
        builder.append(this._ruleBase);
        builder.append(" + Properties");
        builder.append(newLine);
        for (String key : this.keySet()) {
            builder.append("   - " + key + "=" + this.get(key));
            builder.append(newLine);
        }
        return builder.toString();
    }
}

