/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.descriptions.fields;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class ElementDescriptionGroup
implements SelectionListener,
FocusListener,
KeyListener {
    protected EObject _semanticElement;
    protected EStructuralFeature _semanticFeature;
    protected Text _descriptionTextField;

    public ElementDescriptionGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        Group textGroup = new Group(parent, 0);
        if (widgetFactory != null) {
            widgetFactory.adapt((Composite)textGroup);
        }
        textGroup.setLayout((Layout)new GridLayout());
        textGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDescriptionField(textGroup, widgetFactory);
    }

    public void dispose() {
        if (this._descriptionTextField != null && !this._descriptionTextField.isDisposed()) {
            this._descriptionTextField.dispose();
        }
    }

    private void createDescriptionField(Group textGroup, TabbedPropertySheetWidgetFactory widgetFactory) {
        this._descriptionTextField = this.createDescriptionField((Composite)textGroup);
        GridData gd = new GridData(4, 4, true, true);
        this._descriptionTextField.setLayoutData((Object)gd);
        this._descriptionTextField.setEditable(false);
        this._descriptionTextField.addFocusListener((FocusListener)this);
    }

    protected Text createDescriptionField(Composite parent) {
        return new Text(parent, 2626);
    }

    public void setEnabled(boolean enabled) {
        if (this._descriptionTextField != null && !this._descriptionTextField.isDisposed()) {
            this._descriptionTextField.setEditable(enabled);
        }
    }

    public void loadData(EObject element, EStructuralFeature feature) {
        this._semanticElement = element;
        this._semanticFeature = feature;
        this.setTextValue(this._descriptionTextField, this._semanticElement, this._semanticFeature);
    }

    protected void setTextValue(Text text, EObject object, EStructuralFeature feature) {
        String newTextValue;
        if (text == null || object == null || feature == null) {
            return;
        }
        Object value = object.eGet(feature);
        String currentTextValue = text.getText();
        if (!currentTextValue.equals(newTextValue = (String)(value instanceof String ? value : "")) || "".equals(currentTextValue)) {
            text.setText(newTextValue);
        }
    }

    protected abstract void setDataValue(EObject var1, EStructuralFeature var2, Object var3);

    public void saveDescription(String newDescription) {
        this.setDataValue(this._semanticElement, this._semanticFeature, newDescription);
    }

    public void save(String value) {
        this.saveDescription(value);
    }

    public String getValueToSave() {
        return this._descriptionTextField.getText();
    }

    protected void fillTextField(Text textField) {
        if (textField.equals(this._descriptionTextField)) {
            this.setDataValue(this._semanticElement, this._semanticFeature, this._descriptionTextField.getText());
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null && source instanceof Text) {
            this.fillTextField((Text)source);
        }
    }

    public void keyPressed(KeyEvent event) {
        Object source;
        if (event != null && event.character == '\r' && (source = event.getSource()) != null && source instanceof Text) {
            this.fillTextField((Text)source);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

