/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IRestraintProperty;
import org.polarsys.capella.common.flexibility.wizards.Activator;
import org.polarsys.capella.common.flexibility.wizards.renderer.TextRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.utils.CollectionExt;

public class BrowseRenderer
extends TextRenderer {
    ToolItem browse;
    ToolItem delete;

    protected boolean isDeleteButton() {
        return false;
    }

    protected boolean isBrowseButton() {
        return true;
    }

    protected void setBrowseEnabled(boolean enabled) {
        if (this.browse != null) {
            this.browse.setEnabled(enabled);
        }
    }

    protected void setDeleteEnabled(boolean enabled) {
        if (this.delete != null) {
            this.delete.setEnabled(enabled);
        }
    }

    @Override
    protected boolean isEditable(IProperty property, IRendererContext context) {
        return false;
    }

    @Override
    protected int getNbColumn() {
        return super.getNbColumn() + (this.isBrowseButton() ? 1 : 0) + (this.isDeleteButton() ? 1 : 0);
    }

    @Override
    protected void initializeControls(final Composite parent, final IRendererContext context) {
        super.initializeControls(parent, context);
        ToolBar toolbar = new ToolBar(parent, 256);
        if (this.isBrowseButton()) {
            this.browse = new ToolItem(toolbar, 8);
            this.browse.setToolTipText(this.getBrowseText());
            this.browse.setImage(Activator.getDefault().getImage("full/etool16/browse.gif"));
            this.browse.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseRenderer.this.proceedBrowse(parent.getShell(), context);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.isDeleteButton()) {
            this.delete = new ToolItem(toolbar, 8);
            this.delete.setToolTipText("Delete all elements");
            this.delete.setImage(Activator.getDefault().getImage("full/etool16/delete_edit.gif"));
            this.delete.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseRenderer.this.proceedDelete(parent.getShell(), context);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    protected String getBrowseText() {
        return "Browse available elements";
    }

    protected void proceedDelete(Shell shell, IRendererContext context) {
        IProperty property = context.getProperty(this);
        if (property instanceof IRestraintProperty) {
            IRestraintProperty restraintProperty = (IRestraintProperty)property;
            if (!restraintProperty.isMany()) {
                this.changeValue(property, context, context.getPropertyContext().getDefaultValue(property));
                this.updatedValue(property, context, context.getPropertyContext().getDefaultValue(property));
            } else {
                ArrayList result = new ArrayList();
                this.changeValue(property, context, result);
                this.updatedValue(property, context, result);
            }
        }
    }

    protected void proceedBrowse(Shell shell, IRendererContext context) {
        IProperty property = context.getProperty(this);
        if (property instanceof IRestraintProperty) {
            IPropertyContext propertyContext = context.getPropertyContext();
            IRestraintProperty restraintProperty = (IRestraintProperty)property;
            if (!restraintProperty.isMany()) {
                List dialogResult;
                HashSet<EObject> scope = new HashSet<EObject>();
                EObject current = (EObject)propertyContext.getCurrentValue(context.getProperty(this));
                scope.add(current);
                scope.add((EObject)restraintProperty.getValue(propertyContext));
                scope.addAll(restraintProperty.getChoiceValues(propertyContext));
                scope.remove(null);
                SelectElementsDialog dialog = new SelectElementsDialog(shell, TransactionHelper.getEditingDomain(scope), CapellaAdapterFactoryProvider.getInstance().getAdapterFactory(), "Selection wizard", "Select element.", new ArrayList(scope), false, null);
                if (dialog.open() == 0 && (dialogResult = dialog.getResult()) != null) {
                    this.changeValue(property, context, dialogResult.get(0));
                    this.updatedValue(property, context, dialogResult.get(0));
                }
            } else {
                Collection current = (Collection)propertyContext.getCurrentValue((IProperty)restraintProperty);
                HashSet left = new HashSet();
                left.addAll((Collection)restraintProperty.getValue(propertyContext));
                left.addAll(restraintProperty.getChoiceValues(propertyContext));
                left.removeAll(current);
                left.remove(null);
                HashSet right = new HashSet();
                right.addAll(current);
                right.remove(null);
                Collection list = CollectionExt.mergeCollections(left, right);
                TransferTreeListDialog dialog = new TransferTreeListDialog(shell, "Selection wizard", "Select elements.", TransactionHelper.getEditingDomain((Collection)list), CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
                dialog.setLeftInput(new ArrayList(left), null);
                dialog.setRightInput(new ArrayList(right), null);
                if (dialog.open() == 0) {
                    Object[] dialogResult = dialog.getResult();
                    ArrayList<Object> result = new ArrayList<Object>();
                    if (dialogResult != null) {
                        Object[] objectArray = dialogResult;
                        int n = dialogResult.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object res = objectArray[n2];
                            result.add(res);
                            ++n2;
                        }
                    }
                    this.changeValue(property, context, result);
                    this.updatedValue(property, context, result);
                }
            }
        }
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.browse != null) {
            this.browse.dispose();
        }
        if (this.delete != null) {
            this.delete.dispose();
        }
    }
}

