/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui.util;

import javax.inject.Inject;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.util.RendererSelectionService;
import org.polarsys.capella.common.flexibility.wizards.ui.util.SlavePopulatorHandlerService;
import org.polarsys.capella.common.flexibility.wizards.ui.util.SlavePopulatorMenuService;

public class ToolbarPopulator
implements ISelectionListener,
PropertyChangeListener,
IDisposable {
    @Inject
    IEclipseContext context;
    String location;
    IRenderer renderer;
    IServiceLocator parent;
    IServiceLocator locator;
    ISelectionProvider provider;
    IRendererContext rendererContext;
    ContributionManager contributionManager;

    public ToolbarPopulator(ContributionManager contributionManager, String location, IRendererContext rendererContext, IRenderer renderer, ISelectionProvider provider, IServiceLocator parent) {
        this.contributionManager = contributionManager;
        this.location = location;
        this.provider = provider;
        this.parent = parent;
        this.renderer = renderer;
        this.rendererContext = rendererContext;
    }

    public void populate() {
        if (this.location == null || this.location.isEmpty()) {
            return;
        }
        IServiceLocator parentLocator = this.parent;
        ServiceLocator locator = new ServiceLocator(parentLocator, null, (IDisposable)this);
        locator.setContext(this.context);
        this.locator = locator;
        RendererSelectionService newService = new RendererSelectionService(this.rendererContext, this.renderer, this.provider);
        newService.addSelectionListener(this);
        locator.registerService(ISelectionService.class, (Object)newService);
        IEvaluationService parentService = (IEvaluationService)parentLocator.getService(IEvaluationService.class);
        locator.registerService(IEvaluationService.class, (Object)parentService);
        parentService.addSourceProvider((ISourceProvider)newService);
        locator.registerService(ISourceProvider.class, (Object)newService);
        SlavePopulatorHandlerService handlerService = new SlavePopulatorHandlerService((IHandlerService)parentLocator.getService(IHandlerService.class), (IServiceLocator)locator);
        locator.registerService(IHandlerService.class, (Object)handlerService);
        IMenuService menuService = (IMenuService)parentLocator.getService(IMenuService.class);
        SlavePopulatorMenuService slaveMenuService = new SlavePopulatorMenuService(menuService, (IServiceLocator)locator, null);
        slaveMenuService.populateContributionManager(this.contributionManager, this.location);
        this.selectionChanged(null, (ISelection)StructuredSelection.EMPTY);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEvaluationContext currentState = ((IHandlerService)this.context.get(IHandlerService.class)).getCurrentState();
        currentState.addVariable("selection", (Object)selection);
        ISourceProvider provider = (ISourceProvider)this.locator.getService(ISourceProvider.class);
        IEvaluationService parentService = (IEvaluationService)this.parent.getService(IEvaluationService.class);
        parentService.removeSourceProvider(provider);
        parentService.addSourceProvider(provider);
    }

    public void update(PropertyChangedEvent event) {
        ISelectionService service = (ISelectionService)this.locator.getService(ISelectionService.class);
        ISelectionChangedListener sChanged = (ISelectionChangedListener)service;
        sChanged.selectionChanged(new SelectionChangedEvent(this.provider, this.provider.getSelection()));
    }

    public void dispose() {
        if (this.parent != null && this.locator != null) {
            ISourceProvider provider = (ISourceProvider)this.locator.getService(ISourceProvider.class);
            IEvaluationService parentService = (IEvaluationService)this.parent.getService(IEvaluationService.class);
            if (provider != null) {
                parentService.removeSourceProvider(provider);
            }
        }
    }
}

