/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.navigation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.xtext.ide.editor.navigation.INavigatable;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class NavigationService {
    @Inject
    private IURIEditorOpener uriEditorOpener;

    public void open(OpenEvent openEvent) {
        this.open(openEvent, true);
    }

    public void open(OpenEvent openEvent, boolean select) {
        ISelection selection = openEvent.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator _iterator = ((IStructuredSelection)selection).iterator();
            Iterable _iterable = IteratorExtensions.toIterable((Iterator)_iterator);
            Iterable _filter = Iterables.filter((Iterable)_iterable, INavigatable.class);
            for (INavigatable navigatable : _filter) {
                this.open(navigatable, select);
            }
        }
    }

    public void open(INavigatable navigatable) {
        this.open(navigatable, true);
    }

    public void open(INavigatable navigatable, boolean select) {
        Object _navigationElement = null;
        if (navigatable != null) {
            _navigationElement = navigatable.getNavigationElement();
        }
        Object navigatableElement = _navigationElement;
        boolean _matched = false;
        if (navigatableElement instanceof IReferenceDescription) {
            _matched = true;
            URI _sourceEObjectUri = ((IReferenceDescription)navigatableElement).getSourceEObjectUri();
            EReference _eReference = ((IReferenceDescription)navigatableElement).getEReference();
            int _indexInList = ((IReferenceDescription)navigatableElement).getIndexInList();
            this.uriEditorOpener.open(_sourceEObjectUri, _eReference, _indexInList, select);
        }
        if (!_matched && navigatableElement instanceof IEObjectDescription) {
            _matched = true;
            URI _eObjectURI = ((IEObjectDescription)navigatableElement).getEObjectURI();
            this.uriEditorOpener.open(_eObjectURI, select);
        }
        if (!_matched && navigatableElement instanceof IResourceDescription) {
            _matched = true;
            URI _uRI = ((IResourceDescription)navigatableElement).getURI();
            this.uriEditorOpener.open(_uRI, select);
        }
        if (!_matched && navigatableElement instanceof INavigatable) {
            _matched = true;
            this.open((INavigatable)navigatableElement, select);
        }
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(StructuredViewer viewer) {
        return this.installNavigationSupport(viewer, true);
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(StructuredViewer viewer, final boolean select) {
        Procedures.Procedure1<OpenEvent> _function = new Procedures.Procedure1<OpenEvent>(){

            public void apply(OpenEvent it) {
                NavigationService.this.open(it, select);
            }
        };
        return this.installNavigationSupport(viewer, (Procedures.Procedure1<? super OpenEvent>)_function);
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(final StructuredViewer viewer, final Procedures.Procedure1<? super OpenEvent> opener) {
        return new OpenAndLinkWithEditorHelper(viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    OpenEvent _openEvent = new OpenEvent((Viewer)viewer, selection);
                    opener.apply((Object)_openEvent);
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                OpenEvent _openEvent = new OpenEvent((Viewer)viewer, selection);
                opener.apply((Object)_openEvent);
            }
        };
    }
}

