/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.linkedtext.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextCategories;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;

public class LinkedTextDocument
extends Document
implements ILabelProviderListener {
    private static final Pattern pattern = Pattern.compile("<a href=\"([^\"]*)\"/>");
    private final Object _documentBase;
    private final ILabelProvider _labelProvider;
    private final Resolver _resolver;

    public LinkedTextDocument(Object documentBase, ILabelProvider labelProvider, Resolver resolver) {
        this._labelProvider = labelProvider;
        this._documentBase = documentBase;
        this._resolver = resolver;
        this._labelProvider.addListener((ILabelProviderListener)this);
    }

    public final Object getDocumentBase() {
        return this._documentBase;
    }

    public final ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    public final Resolver getResolver() {
        return this._resolver;
    }

    protected void completeInitialization() {
        super.completeInitialization();
        this.addPositionCategory(LinkedTextCategories.HYPERLINK.name());
        this.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(LinkedTextCategories.HYPERLINK.name()));
    }

    public static LinkedTextDocument load(Input input) {
        LinkedTextDocument doc = new LinkedTextDocument(input.getDocumentBase(), input.getLabelProvider(), input.getResolver());
        ArrayList<LinkedTextHyperlink> links = new ArrayList<LinkedTextHyperlink>();
        if (input.getText() != null) {
            Matcher m = pattern.matcher(input.getText());
            StringBuilder builder = new StringBuilder();
            int offset = 0;
            while (m.find()) {
                int n = m.start();
                if (n > offset) {
                    builder.append(StringEscapeUtils.unescapeHtml((String)input.getText().substring(offset, n)));
                }
                int labelStart = builder.length();
                Object target = doc.getResolver().getTarget(doc.getDocumentBase(), m.group(1));
                String text = null;
                text = target != null ? doc.getLabelProvider().getText(target) : m.group(1);
                LinkedTextHyperlink hl = LinkedTextHyperlink.create(labelStart, text.length(), target);
                builder.append(text);
                links.add(hl);
                offset = m.end();
            }
            builder.append(StringEscapeUtils.unescapeHtml((String)input.getText().substring(offset, input.getText().length())));
            doc.set(builder.toString());
            for (Position position : links) {
                try {
                    doc.addPosition(LinkedTextCategories.HYPERLINK.name(), position);
                }
                catch (BadLocationException exception) {
                    exception.printStackTrace();
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    // empty catch block
                }
            }
        }
        return doc;
    }

    public void insertHyperlink(LinkedTextHyperlink hl) throws BadLocationException {
        this.stopListenerNotification();
        this.replace(hl.getOffset(), 0, this._labelProvider.getText(hl.getTarget()));
        try {
            this.addPosition(LinkedTextCategories.HYPERLINK.name(), hl);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        this.resumeListenerNotification();
    }

    public Collection<LinkedTextHyperlink> getHyperlinks() {
        ArrayList<LinkedTextHyperlink> result = new ArrayList<LinkedTextHyperlink>();
        try {
            Position[] positionArray = this.getPositions(LinkedTextCategories.HYPERLINK.name());
            int n = positionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Position pos = positionArray[n2];
                if (!pos.isDeleted()) {
                    result.add((LinkedTextHyperlink)pos);
                }
                ++n2;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
        return result;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        for (LinkedTextHyperlink hl : this.getHyperlinks()) {
            String newText = null;
            if (event.getElements() == null) {
                newText = this._labelProvider.getText(hl.getTarget());
            } else {
                Object[] objectArray = event.getElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element == hl.getTarget()) {
                        newText = this._labelProvider.getText(hl.getTarget());
                        break;
                    }
                    ++n2;
                }
            }
            if (newText == null) continue;
            try {
                this.replace(hl.getOffset(), hl.getLength(), newText);
            }
            catch (BadLocationException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void dispose() {
        this._labelProvider.removeListener((ILabelProviderListener)this);
    }

    public String saveToRaw() {
        StringBuilder builder = new StringBuilder();
        int offset = 0;
        for (LinkedTextHyperlink current : this.getHyperlinks()) {
            try {
                String segment = this.get(offset, current.getOffset() - offset);
                builder.append(StringEscapeUtils.escapeHtml((String)segment));
            }
            catch (BadLocationException exception) {
                exception.printStackTrace();
            }
            String href = null;
            if (current.getTarget() == null) {
                try {
                    href = this.get(current.getOffset(), current.getLength());
                }
                catch (BadLocationException exception) {
                    exception.printStackTrace();
                }
            } else {
                href = this.getResolver().getHref(this.getDocumentBase(), current.getTarget());
            }
            builder.append("<a href=\"").append(href).append("\"/>");
            offset = current.getOffset() + current.getLength();
        }
        try {
            String segment = this.get(offset, this.getLength() - offset);
            builder.append(StringEscapeUtils.escapeHtml((String)segment));
        }
        catch (BadLocationException exception) {
            exception.printStackTrace();
        }
        return builder.toString();
    }

    public static interface Input {
        public String getText();

        public void setText(String var1);

        public Object getDocumentBase();

        public ILabelProvider getLabelProvider();

        public Resolver getResolver();
    }

    public static interface Resolver {
        public Object getTarget(Object var1, String var2);

        public String getHref(Object var1, Object var2);
    }
}

