/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.commandline.core.IFileImporter;

public class ZipFileImporter
implements IFileImporter {
    public Collection<IProject> importFile(IFile theZipFile, boolean forceImport) {
        try {
            ZipEntry entry;
            ZipFile zipFile = new ZipFile(theZipFile.getFullPath().toOSString());
            IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            ZipLeveledStructureProvider provider = new ZipLeveledStructureProvider(zipFile){

                public List getChildren(Object element) {
                    List parrent = super.getChildren(element);
                    if (parrent == null) {
                        return Collections.emptyList();
                    }
                    return parrent;
                }
            };
            ArrayList<IProject> projects = new ArrayList<IProject>();
            ArrayList fileSystemObjects = new ArrayList();
            HashMap maps = new HashMap();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.getName().endsWith(".project")) continue;
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(zipFile.getInputStream(entry));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                if (!forceImport) {
                    if (project.exists()) {
                        Status status = new Status(4, "org.polarsys.capella.core.commandline.core", "Problem while importing project into the workspace: A project with the same name is referenced from the workspace. This should be removed from the workspace.");
                        LogExt.log((String)"Model Management", (IStatus)status);
                        continue;
                    }
                    project.create(description, null);
                    project.open(null);
                    maps.put(project.getName(), new ArrayList());
                    continue;
                }
                if (project.exists()) {
                    if (ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath()).toFile().exists()) {
                        project.delete(4, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        project.delete(8, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                project.create(description, null);
                project.open(null);
                maps.put(project.getName(), new ArrayList());
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (maps.size() == 1) {
                    ((ArrayList)maps.get(maps.keySet().iterator().next())).add(entry);
                    continue;
                }
                for (String map : maps.keySet()) {
                    if (!entry.getName().startsWith(map)) continue;
                    ((ArrayList)maps.get(map)).add(entry);
                }
            }
            for (String map : maps.keySet()) {
                List files = (List)maps.get(map);
                ImportOperation importOperation = new ImportOperation(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), (Object)new ZipEntry(map), (IImportStructureProvider)provider, overwriteQuery, files);
                importOperation.setCreateContainerStructure(true);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                projects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(map));
            }
            return projects;
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.polarsys.capella.core.commandline.core", exception.getMessage());
            LogExt.log((String)"Model Management", (IStatus)status);
            return Collections.emptyList();
        }
    }
}

