/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IUndecoratingLabelProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.ui.StatusManagerExceptionHandler;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.libraries.ui.move.CollectionTreeFilter;
import org.polarsys.capella.core.libraries.ui.move.Messages;
import org.polarsys.capella.core.model.helpers.move.Stage;
import org.polarsys.capella.core.model.helpers.move.StageListener;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.ExplorerDropAdapterAssistant;

public class MoveStagingView
extends ViewPart
implements ISelectionProvider,
ITabbedPropertySheetPageContributor {
    TreeViewer stageViewer;
    TreeViewer destinationViewer;
    ColumnViewerInformationControlToolTipSupport tooltipSupport;
    FormToolkit toolkit;
    final ComposedAdapterFactory cfac = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    Stage stage;
    StageListener listener;
    Form form;
    FormText formText;
    Section stageSection;
    Section destinationSection;
    IAction executeAction;

    public Stage getStage() {
        return this.stage;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        GridLayout layout = new GridLayout(2, true);
        this.form.getBody().setLayout((Layout)layout);
        this.formText = this.toolkit.createFormText(this.form.getBody(), true);
        this.formText.setColor("red", this.toolkit.getColors().createColor("red", this.toolkit.getColors().getSystemColor(3)));
        this.form.setText(Messages.MoveStagingView_formTitle);
        this.formText.setText(Messages.MoveStagingView_formText, true, true);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.formText.setLayoutData((Object)gd);
        this.stageSection = this.toolkit.createSection(this.form.getBody(), 448);
        this.stageSection.setText(Messages.MoveStagingView_stageSectionTitle);
        this.stageSection.setDescription(Messages.MoveStagingView_stageSectionDescription);
        gd = new GridData(4, 4, true, true);
        this.stageSection.setLayoutData((Object)gd);
        Composite stageSectionClient = this.toolkit.createComposite((Composite)this.stageSection);
        stageSectionClient.setLayout((Layout)new GridLayout(2, false));
        this.stageSection.setClient((Control)stageSectionClient);
        this.createStageViewer(stageSectionClient);
        this.destinationSection = this.toolkit.createSection(this.form.getBody(), 448);
        this.destinationSection.setText(Messages.MoveStagingView_destinationSectionTitle);
        this.destinationSection.setDescription(Messages.MoveStagingView_destinationSectionDescription);
        gd = new GridData(4, 4, true, true);
        this.destinationSection.setLayoutData((Object)gd);
        Composite destinationSectionClient = this.toolkit.createComposite((Composite)this.destinationSection);
        destinationSectionClient.setLayout((Layout)new GridLayout(2, false));
        this.destinationSection.setClient((Control)destinationSectionClient);
        this.createDestinationViewer(destinationSectionClient);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        this.initTreePacker();
        this.initSelectionSynchronizer();
        this.initToolbar();
    }

    private void initToolbar() {
        ImageDescriptor descriptor = DebugPluginImages.getImageRegistry().getDescriptor("IMG_ACT_RUN");
        this.executeAction = new Action("", descriptor){

            public void run() {
                TransactionalCommandStack stack = (TransactionalCommandStack)MoveStagingView.this.stage.getEditingDomain().getCommandStack();
                ExceptionHandler oldHandler = stack.getExceptionHandler();
                TransactionErrorHandler newHandler = new TransactionErrorHandler();
                stack.setExceptionHandler((ExceptionHandler)newHandler);
                IStatus result = null;
                try {
                    result = MoveStagingView.this.stage.execute();
                }
                finally {
                    stack.setExceptionHandler(oldHandler);
                    if (result != null) {
                        if (result.isOK()) {
                            if (!newHandler.handledException) {
                                MoveStagingView.this.reset();
                            }
                        } else {
                            StatusManager.getManager().handle(result, 2);
                        }
                    }
                }
            }
        };
        this.executeAction.setEnabled(false);
        this.getViewSite().getActionBars().getToolBarManager().add(this.executeAction);
    }

    private void initSelectionSynchronizer() {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewer target = null;
                if (((TreeViewer)event.getSelectionProvider()).getTree().isFocusControl()) {
                    target = event.getSelectionProvider() == MoveStagingView.this.stageViewer ? MoveStagingView.this.destinationViewer : MoveStagingView.this.stageViewer;
                    if (((IStructuredSelection)event.getSelection()).size() == 1) {
                        Object elem = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (MoveStagingView.this.stage.getElements().contains(elem)) {
                            target.setSelection(event.getSelection());
                            target.reveal(elem);
                        }
                    }
                }
            }
        };
        this.stageViewer.addSelectionChangedListener(listener);
        this.destinationViewer.addSelectionChangedListener(listener);
    }

    private void initTreePacker() {
        TreeListener packer = new TreeListener(){

            private void pack(final TreeEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!e.widget.isDisposed()) {
                            ((Tree)e.widget).getColumn(0).pack();
                        }
                    }
                });
            }

            public void treeExpanded(TreeEvent e) {
                this.pack(e);
            }

            public void treeCollapsed(TreeEvent e) {
                this.pack(e);
            }
        };
        this.stageViewer.getTree().addTreeListener(packer);
        this.destinationViewer.getTree().addTreeListener(packer);
    }

    private void createStageViewer(Composite stageSectionClient) {
        this.stageViewer = new TreeViewer(this.toolkit.createTree(stageSectionClient, 2050));
        GridData gd = new GridData(4, 4, true, true);
        this.stageViewer.getTree().setLayoutData((Object)gd);
        TreeColumn column = new TreeColumn(this.stageViewer.getTree(), 16384);
        column.setWidth(200);
        this.stageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)){

            public Object[] getElements(Object object) {
                LinkedHashSet<EObject> elems = new LinkedHashSet<EObject>();
                for (EObject e : MoveStagingView.this.stage.getElements()) {
                    elems.add(EcoreUtil.getRootContainer((EObject)e));
                }
                return elems.toArray();
            }

            public Object getParent(Object object) {
                return ((EObject)object).eContainer();
            }
        });
        this.stageViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.stageViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
                if (sel instanceof IStructuredSelection) {
                    ArrayList<EObject> eObjects = new ArrayList<EObject>();
                    for (Object next : (IStructuredSelection)sel) {
                        if (next instanceof EObject) {
                            eObjects.add((EObject)next);
                            continue;
                        }
                        return false;
                    }
                    TransactionalEditingDomain editingDomain = EcoreUtil2.getEditingDomain(eObjects);
                    if (editingDomain == null) {
                        return false;
                    }
                    if (MoveStagingView.this.stage == null || MoveStagingView.this.stage.getEditingDomain() == editingDomain && Collections.disjoint(MoveStagingView.this.stage.getElements(), eObjects)) {
                        return true;
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                List dropped = ((IStructuredSelection)data).toList();
                if (MoveStagingView.this.stage == null) {
                    MoveStagingView.this.stage = new Stage(EcoreUtil2.getEditingDomain((Collection)dropped));
                    MoveStagingView.this.listener = new StageListener(){

                        public void stageChanged(Stage s) {
                            MoveStagingView.this.handleStageChanged(s);
                        }

                        public void elementsAdded(Collection<EObject> elements) {
                            MoveStagingView.this.handleStageElementsAdded(elements);
                        }

                        public void parentChanged(EObject staged, EObject oldParent, EObject newParent) {
                            MoveStagingView.this.handleStageParentChanged(staged, oldParent, newParent);
                        }

                        public void elementsRemoved(Collection<? extends EObject> elements) {
                            MoveStagingView.this.handleStageElementsRemoved(elements);
                        }
                    };
                    MoveStagingView.this.stage.addStageListener(MoveStagingView.this.listener);
                    MoveStagingView.this.stageViewer.setInput((Object)MoveStagingView.this.stage.getEditingDomain().getResourceSet());
                    MoveStagingView.this.stageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new LabelProvider((AdapterFactory)MoveStagingView.this.cfac, (Viewer)MoveStagingView.this.stageViewer), (ILabelDecorator)new StageLabelDecorator()));
                    MoveStagingView.this.stageViewer.setFilters(new ViewerFilter[]{new CollectionTreeFilter(MoveStagingView.this.stage.getElements(), false)});
                    MoveStagingView.this.tooltipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)MoveStagingView.this.stageViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener(MoveStagingView.this.stage.getEditingDomain(), (StructuredViewer)MoveStagingView.this.stageViewer));
                    MoveStagingView.this.destinationViewer.setInput((Object)MoveStagingView.this.stage.getEditingDomain().getResourceSet());
                }
                MoveStagingView.this.stage.addAll((Collection)dropped);
                return true;
            }
        });
        this.stageViewer.addDragSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ViewerDragAdapter((Viewer)this.stageViewer){

            public void dragStart(DragSourceEvent event) {
                if (MoveStagingView.this.stage.getElements().containsAll(MoveStagingView.this.stageViewer.getStructuredSelection().toList())) {
                    super.dragStart(event);
                } else {
                    event.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                MoveStagingView.this.stageViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                MoveStagingView.this.stageViewer.refresh();
            }
        });
        ToolBarManager stageViewerToolBarManager = new ToolBarManager(0x800200);
        ToolBar stageViewerToolbar = stageViewerToolBarManager.createControl(stageSectionClient);
        gd = new GridData(0x1000000, 128, false, false);
        stageViewerToolbar.setLayoutData((Object)gd);
        ImageDescriptor descriptor = DebugPluginImages.getImageRegistry().getDescriptor("IMG_LCL_REMOVE");
        Action unstageAction = new Action("", descriptor){

            public void run() {
                if (MoveStagingView.this.stage != null) {
                    MoveStagingView.this.stage.removeAll((Collection)MoveStagingView.this.stageViewer.getStructuredSelection().toList());
                }
            }
        };
        unstageAction.setToolTipText(Messages.MoveStagingView_unstageActionTooltip);
        this.stageViewer.addSelectionChangedListener(new ISelectionChangedListener((IAction)unstageAction){
            private final /* synthetic */ IAction val$unstageAction;
            {
                this.val$unstageAction = iAction;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.val$unstageAction.setEnabled(MoveStagingView.this.stage.getElements().containsAll(MoveStagingView.this.stageViewer.getStructuredSelection().toList()));
            }
        });
        unstageAction.setEnabled(false);
        stageViewerToolBarManager.add((IAction)unstageAction);
        stageViewerToolBarManager.update(true);
        MenuManager stageContextMenu = new MenuManager();
        stageContextMenu.add((IContributionItem)new Separator("additions"));
        this.stageViewer.getControl().setMenu(stageContextMenu.createContextMenu(this.stageViewer.getControl()));
        this.getViewSite().registerContextMenu("org.polarsys.capella.core.libraries.ui.moveview.stageViewer", stageContextMenu, (ISelectionProvider)this.stageViewer);
    }

    private void createDestinationViewer(Composite destinationSectionClient) {
        this.destinationViewer = new TreeViewer(this.toolkit.createTree(destinationSectionClient, 2050));
        TreeColumn column2 = new TreeColumn(this.destinationViewer.getTree(), 16384);
        column2.setWidth(200);
        GridData gd = new GridData(4, 4, true, true);
        this.destinationViewer.getControl().setLayoutData((Object)gd);
        this.destinationViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new LabelProvider((AdapterFactory)this.cfac, (Viewer)this.destinationViewer), (ILabelDecorator)new StageLabelDecorator()));
        this.destinationViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.cfac){

            public Object[] getElements(Object object) {
                ArrayList<Project> result = new ArrayList<Project>();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)object);
                IModel model = LibraryManager.INSTANCE.getModel(domain);
                for (IModel lib : LibraryManagerExt.getAllReferences((IModel)model)) {
                    if (!(lib instanceof ICapellaModel)) continue;
                    result.add(((ICapellaModel)lib).getProject(domain));
                }
                return result.toArray();
            }

            public boolean hasChildren(Object object) {
                for (Object o : MoveStagingView.this.stage.getElements()) {
                    if (MoveStagingView.this.stage.getNewParent((EObject)o) != object) continue;
                    return true;
                }
                return super.hasChildren(object);
            }

            public Object[] getChildren(Object element) {
                Object[] realChildren;
                ArrayList<EObject> newChildren = null;
                for (EObject e : MoveStagingView.this.stage.getElements()) {
                    if (element != MoveStagingView.this.stage.getNewParent(e)) continue;
                    if (newChildren == null) {
                        newChildren = new ArrayList<EObject>();
                    }
                    newChildren.add(e);
                }
                Object[] result = realChildren = super.getChildren(element);
                if (newChildren != null) {
                    result = new Object[realChildren.length + newChildren.size()];
                    System.arraycopy(realChildren, 0, result, 0, realChildren.length);
                    System.arraycopy(newChildren.toArray(), 0, result, realChildren.length, newChildren.size());
                }
                return result;
            }
        });
        this.destinationViewer.addDropSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.destinationViewer){
            final ExplorerDropAdapterAssistant a;
            {
                this.a = new ExplorerDropAdapterAssistant();
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                ISelection sel;
                IWorkbenchPart active;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (active = MoveStagingView.this.getSite().getPage().getActivePart()) == MoveStagingView.this && (sel = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                    List selected = ((IStructuredSelection)sel).toList();
                    if (MoveStagingView.this.stage != null && MoveStagingView.this.stage.getElements().containsAll(selected)) {
                        return this.a.validateDrop(target, operation, transferType).isOK();
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                List staged = ((IStructuredSelection)data).toList();
                for (EObject e : staged) {
                    MoveStagingView.this.stage.setParent(e, (EObject)this.getCurrentTarget());
                }
                return true;
            }
        });
        this.destinationViewer.addDragSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ViewerDragAdapter((Viewer)this.destinationViewer){

            public void dragStart(DragSourceEvent event) {
                if (!MoveStagingView.this.stage.getElements().containsAll(((IStructuredSelection)this.viewer.getSelection()).toList())) {
                    event.doit = false;
                }
                super.dragStart(event);
            }
        });
        ToolBarManager destinationViewerToolBarManager = new ToolBarManager(0x800200);
        ToolBar destinationViewerToolbar = destinationViewerToolBarManager.createControl(destinationSectionClient);
        gd = new GridData(0x1000000, 128, false, false);
        destinationViewerToolbar.setLayoutData((Object)gd);
        ImageDescriptor descriptor = DebugPluginImages.getImageRegistry().getDescriptor("IMG_LCL_REMOVE");
        Action clearParentAction = new Action("", descriptor){

            public void run() {
                for (Object e : MoveStagingView.this.destinationViewer.getStructuredSelection().toList()) {
                    MoveStagingView.this.stage.setParent((EObject)e, null);
                }
            }
        };
        clearParentAction.setToolTipText(Messages.MoveStagingView_clearParentActionTooltip);
        this.destinationViewer.addSelectionChangedListener(new ISelectionChangedListener((IAction)clearParentAction){
            private final /* synthetic */ IAction val$clearParentAction;
            {
                this.val$clearParentAction = iAction;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.val$clearParentAction.setEnabled(MoveStagingView.this.stage.getElements().containsAll(MoveStagingView.this.destinationViewer.getStructuredSelection().toList()));
            }
        });
        clearParentAction.setEnabled(false);
        destinationViewerToolBarManager.add((IAction)clearParentAction);
        destinationViewerToolBarManager.update(true);
        MenuManager destinationContextMenu = new MenuManager();
        destinationContextMenu.add((IContributionItem)new Separator("additions"));
        this.destinationViewer.getControl().setMenu(destinationContextMenu.createContextMenu(this.destinationViewer.getControl()));
        this.getViewSite().registerContextMenu("org.polarsys.capella.core.libraries.ui.moveview.destinationViewer", destinationContextMenu, (ISelectionProvider)this.destinationViewer);
    }

    public void setFocus() {
        this.stageViewer.getControl().setFocus();
    }

    private void handleStageChanged(Stage s) {
        this.stageViewer.refresh(true);
        this.destinationViewer.refresh(true);
        this.stageViewer.getTree().getColumn(0).pack();
        this.updateActions();
    }

    private void handleStageElementsAdded(Collection<EObject> elements) {
        this.handleStageChanged(this.stage);
        for (EObject e : elements) {
            this.stageViewer.reveal((Object)e);
        }
        TreeIterator it = EcoreUtil.getAllContents(elements);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!this.stage.hasBackreferences(next)) continue;
            this.stageViewer.reveal((Object)next);
        }
        this.stageViewer.getTree().getColumn(0).pack();
    }

    private void handleStageParentChanged(EObject staged, EObject oldParent, EObject newParent) {
        if (oldParent != null) {
            this.destinationViewer.refresh((Object)oldParent, true);
        }
        this.destinationViewer.refresh((Object)newParent, true);
        if (newParent != null) {
            this.destinationViewer.setExpandedState((Object)newParent, true);
        } else {
            this.stageViewer.update((Object)staged, null);
        }
        this.destinationViewer.getTree().getColumn(0).pack();
        this.updateActions();
    }

    private void handleStageElementsRemoved(Collection<? extends EObject> elements) {
        this.stageViewer.refresh(true);
        this.destinationViewer.refresh(true);
        this.stageViewer.getTree().getColumn(0).pack();
        this.destinationViewer.getTree().getColumn(0).pack();
        this.updateActions();
    }

    private void updateActions() {
        this.executeAction.setEnabled(this.stage.canExecute());
    }

    public void reset() {
        this.stageViewer.setInput(null);
        this.destinationViewer.setInput(null);
        if (this.stage != null) {
            if (this.listener != null) {
                this.stage.removeStageListener(this.listener);
            }
            this.stage.dispose();
            this.stage = null;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.stageViewer.addSelectionChangedListener(listener);
        this.destinationViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.stageViewer.getControl().isFocusControl() ? this.stageViewer.getSelection() : this.destinationViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.stageViewer.removeSelectionChangedListener(listener);
        this.destinationViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.stageViewer.setSelection(selection);
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.cfac.dispose();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        if (this.stage != null) {
            this.stage.dispose();
        }
        if (this.tooltipSupport != null) {
            this.tooltipSupport.dispose();
        }
    }

    class LabelProvider
    extends AdapterFactoryLabelProvider.FontAndColorProvider {
        Font boldFont;
        Font italicFont;

        public LabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
            super(adapterFactory, viewer);
            this.boldFont = null;
            this.italicFont = null;
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
        }

        public Font getFont(Object object) {
            if (MoveStagingView.this.stage.getElements().contains(object)) {
                if (this.boldFont == null) {
                    FontDescriptor descriptor = FontDescriptor.createFrom((Font)this.getDefaultFont()).setStyle(1);
                    this.boldFont = descriptor.createFont(this.getDefaultFont().getDevice());
                }
                return this.boldFont;
            }
            if (object instanceof EObject && EcoreUtil.isAncestor((Collection)MoveStagingView.this.stage.getElements(), (EObject)((EObject)object))) {
                return this.getDefaultFont();
            }
            if (this.italicFont == null) {
                FontDescriptor descriptor = FontDescriptor.createFrom((Font)this.getDefaultFont()).setStyle(2);
                this.italicFont = descriptor.createFont(this.getDefaultFont().getDevice());
            }
            return this.italicFont;
        }

        public Color getForeground(Object object) {
            if (MoveStagingView.this.stage.hasBackreferences((EObject)object)) {
                return Display.getCurrent().getSystemColor(3);
            }
            if (MoveStagingView.this.stage.getNewParent((EObject)object) != null) {
                return Display.getCurrent().getSystemColor(5);
            }
            return super.getForeground(object);
        }
    }

    class StageLabelDecorator
    extends CellLabelProvider
    implements ILabelDecorator {
        StageLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            Collection diagnostic = MoveStagingView.this.stage.getDiagnostics((EObject)element);
            for (Diagnostic diag : diagnostic) {
                if (diagnostic == null || diag.getSeverity() < 2) continue;
                return this.decorate(image, diag);
            }
            return image;
        }

        public Image decorate(Image image, Diagnostic diagnostic) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
            ComposedImage composedImage = new ComposedImage(images);
            return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        protected void buildToolTipMessage(StringBuilder result, ILabelProvider labelProvider, Object object, Diagnostic diagnostic) {
            String message = diagnostic.getMessage();
            ImageDescriptor imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
            EObject target = (EObject)diagnostic.getData().get(1);
            EReference ref = (EReference)diagnostic.getData().get(2);
            result.append("<div>");
            String sourceText = DiagnosticDecorator.escapeContent((String)labelProvider.getText(object));
            URI sourceImage = ImageURIRegistry.INSTANCE.getImageURI(labelProvider.getImage(object));
            String targetText = DiagnosticDecorator.escapeContent((String)labelProvider.getText((Object)target));
            URI targetImage = ImageURIRegistry.INSTANCE.getImageURI(labelProvider.getImage((Object)target));
            result.append(sourceText);
            result.append(String.format(Messages.MoveStagingView_backrefTooltip, sourceImage, EcoreUtil.getURI((EObject)target), targetText, targetImage, DiagnosticDecorator.escapeContent((String)labelProvider.getText((Object)ref))));
            result.append("</div>");
        }

        public String getToolTipText(Object element) {
            Collection diags = MoveStagingView.this.stage.getDiagnostics((EObject)element);
            if (diags != null && diags.size() > 0) {
                Diagnostic d = (Diagnostic)diags.iterator().next();
                StringBuilder builder = new StringBuilder();
                ILabelProvider labelProvider = (ILabelProvider)MoveStagingView.this.stageViewer.getLabelProvider();
                if (labelProvider instanceof IUndecoratingLabelProvider) {
                    final IUndecoratingLabelProvider undecoratingLabelProvider = (IUndecoratingLabelProvider)labelProvider;
                    labelProvider = new ILabelProvider(){

                        public void removeListener(ILabelProviderListener listener) {
                            undecoratingLabelProvider.removeListener(listener);
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return undecoratingLabelProvider.isLabelProperty(element, property);
                        }

                        public void dispose() {
                            undecoratingLabelProvider.dispose();
                        }

                        public void addListener(ILabelProviderListener listener) {
                            undecoratingLabelProvider.addListener(listener);
                        }

                        public String getText(Object element) {
                            return undecoratingLabelProvider.getUndecoratedText(element);
                        }

                        public Image getImage(Object element) {
                            return undecoratingLabelProvider.getUndecoratedImage(element);
                        }
                    };
                }
                this.buildToolTipMessage(builder, labelProvider, element, d);
                return builder.toString();
            }
            return null;
        }

        public void update(ViewerCell cell) {
        }
    }

    private static class TransactionErrorHandler
    extends StatusManagerExceptionHandler {
        boolean handledException = false;

        TransactionErrorHandler() {
            super(3);
        }

        public void handleException(Exception e) {
            this.handledException = true;
            super.handleException(e);
        }
    }
}

