/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationModelHelpers;

public abstract class DeleteElementAction
extends Action {
    protected TreeViewer treeViewer;
    protected IStructuredSelection selection;

    public DeleteElementAction(IStructuredSelection selection, TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.selection = selection;
    }

    public void run() {
        EIAllocationModelHelpers.handleDeletion(this.selection.toList());
        this.postRun();
    }

    protected abstract void postRun();

    public String getText() {
        return "Delete Element";
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    public boolean isEnabled() {
        TreeItem[] selectedItems = this.treeViewer.getTree().getSelection();
        if (selectedItems.length == 1) {
            if (selectedItems[0].getParentItem() == null) {
                return false;
            }
            if (EIAllocationModelHelpers.isValidTypeForDeletion(this.selection.toList())) {
                return true;
            }
        }
        return false;
    }
}

