/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.merge.merger.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.refinement.merge.exception.MergeToolException;
import org.polarsys.capella.core.refinement.merge.helpers.MergeHelper;
import org.polarsys.capella.core.refinement.merge.merger.operations.AbstractMergerOperation;
import org.polarsys.capella.core.refinement.merge.messages.MergeMessages;
import org.polarsys.capella.core.refinement.merge.utils.LinkEnum;
import org.polarsys.capella.core.refinement.merge.utils.LinkUtils;

public class ScenarioDecomposition
extends AbstractMergerOperation {
    protected Scenario _target;
    protected Map<InstanceRole, List<InstanceRole>> _irs;
    protected Map<InstanceRole, List<List<InteractionFragment>>> _strandsMap;

    public Map<InstanceRole, List<InstanceRole>> getIRsMap() {
        return this._irs;
    }

    public Map<InstanceRole, List<List<InteractionFragment>>> getStrandsMap() {
        return this._strandsMap;
    }

    public Scenario getTargetScenario() {
        return this._target;
    }

    public List<List<InteractionFragment>> getStrandsForToReplace(InstanceRole ir) throws MergeToolException {
        if (ir == null || this._irs.get(ir) == null) {
            throw new MergeToolException(MergeMessages.genericInternalError);
        }
        return this._strandsMap.get(ir);
    }

    public ScenarioDecomposition(Scenario target) {
        this._target = target;
    }

    @Override
    public void preOperation() throws MergeToolException {
        this._irs = new HashMap<InstanceRole, List<InstanceRole>>();
        List<InstanceRole> newIRs = null;
        for (InstanceRole ir : this._target.getOwnedInstanceRoles()) {
            newIRs = MergeHelper.getDecomposedIR(ir);
            if (newIRs.isEmpty()) continue;
            Scenario data = (Scenario)newIRs.get(0).eContainer();
            for (InstanceRole ir2 : data.getOwnedInstanceRoles()) {
                if (LinkUtils.hasOutgoingLinks((TraceableElement)ir2, LinkEnum.REFINEMENT_LINK)) continue;
                newIRs.add(ir2);
            }
            this._irs.put(ir, newIRs);
        }
    }

    @Override
    public void perform() {
        this._strandsMap = new HashMap<InstanceRole, List<List<InteractionFragment>>>();
        Scenario dataScenario = null;
        for (InstanceRole irToReplace : this._irs.keySet()) {
            dataScenario = (Scenario)this._irs.get(irToReplace).get(0).eContainer();
            ArrayList strands = new ArrayList();
            ArrayList<InteractionFragment> strand = null;
            boolean isFirstElementHasRL = false;
            for (InteractionFragment ifrag : dataScenario.getOwnedInteractionFragments()) {
                if (strand == null) {
                    strand = new ArrayList<InteractionFragment>();
                    strand.add(ifrag);
                    isFirstElementHasRL = LinkUtils.hasOutgoingLinks((TraceableElement)ifrag, LinkEnum.REFINEMENT_LINK);
                    continue;
                }
                if (isFirstElementHasRL == LinkUtils.hasOutgoingLinks((TraceableElement)ifrag, LinkEnum.REFINEMENT_LINK)) {
                    strand.add(ifrag);
                    continue;
                }
                strands.add(strand);
                strand = new ArrayList();
                strand.add(ifrag);
                isFirstElementHasRL = LinkUtils.hasOutgoingLinks((TraceableElement)ifrag, LinkEnum.REFINEMENT_LINK);
            }
            strands.add(strand);
            this._strandsMap.put(irToReplace, strands);
        }
    }

    @Override
    public void postOperation() throws MergeToolException {
    }
}

