/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public abstract class AbstractInterfaceProcessor
implements IProcessor {
    private CapellaElement context = null;
    private CapellaElement target = null;

    public AbstractInterfaceProcessor() {
    }

    public AbstractInterfaceProcessor(CapellaElement context) {
        this.setContext((ModelElement)context);
    }

    public Object getResult() {
        return null;
    }

    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    public void setContext(ModelElement context) {
        if (context instanceof Component) {
            context = (Component)context;
        } else if (context instanceof ComponentArchitecture) {
            context = (ComponentArchitecture)context;
        } else if (context instanceof Scenario) {
            context = ScenarioExt.getContainer((Scenario)((Scenario)context));
        }
    }

    public void setTarget(NamedElement target) {
        this.target = target;
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        block13: {
            block11: {
                block15: {
                    block14: {
                        block12: {
                            if (this.target != null) break block11;
                            if (!(this.context instanceof LogicalComponent)) break block12;
                            if (ComponentExt.isComposite((Component)((LogicalComponent)this.context))) break block13;
                            this.execute((LogicalComponent)this.context);
                            break block13;
                        }
                        if (!(this.context instanceof LogicalArchitecture)) break block14;
                        for (LogicalComponent lc : SystemEngineeringExt.getAllLogicalComponents((CapellaElement)this.context)) {
                            if (ComponentExt.isComposite((Component)lc)) continue;
                            this.execute(lc);
                        }
                        break block13;
                    }
                    if (!(this.context instanceof PhysicalComponent)) break block15;
                    this.execute((PhysicalComponent)this.context);
                    break block13;
                }
                if (!(this.context instanceof PhysicalArchitecture)) break block13;
                for (PhysicalComponent pc : SystemEngineeringExt.getAllPhysicalComponents((CapellaElement)this.context)) {
                    this.execute(pc);
                }
                break block13;
            }
            if (this.target instanceof PhysicalComponent) {
                this.synchronize((PhysicalComponent)this.target);
            } else if (this.target instanceof PhysicalArchitecture) {
                for (PhysicalComponent pc : SystemEngineeringExt.getAllPhysicalComponents((CapellaElement)this.target)) {
                    this.synchronize(pc);
                }
            } else if (this.target instanceof ConfigurationItem) {
                this.synchronize((ConfigurationItem)this.target);
            } else if (this.target instanceof EPBSArchitecture) {
                for (ConfigurationItem epbs : SystemEngineeringExt.getAllConfigurationItems((CapellaElement)this.target)) {
                    this.synchronize(epbs);
                }
            }
        }
    }

    protected void execute(System currentElt) {
        for (Component implementorLC : currentElt.getAllocatingComponents()) {
            if (!(implementorLC instanceof LogicalComponent)) continue;
            this.synchronize((LogicalComponent)implementorLC);
        }
    }

    protected void execute(LogicalComponent currentElt) {
        for (PhysicalComponent implementorPC : LogicalComponentExt.getImplementors((LogicalComponent)currentElt)) {
            this.synchronize(implementorPC);
        }
    }

    protected void execute(PhysicalComponent currentElt) {
        for (ConfigurationItem implementorEPBS : PhysicalComponentExt.getImplementors((PhysicalComponent)currentElt)) {
            this.synchronize(implementorEPBS);
        }
    }

    protected abstract void synchronize(LogicalComponent var1);

    protected abstract void synchronize(PhysicalComponent var1);

    protected abstract void synchronize(ConfigurationItem var1);
}

