/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortRealization;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class InterfaceDelegationSCtoLC {
    protected List<Map.Entry<Component, Component>> pairs = new ArrayList<Map.Entry<Component, Component>>();

    public InterfaceDelegationSCtoLC(LogicalComponent logicalComponent) {
        this.computeComponentPairsForComponentFromLogicalLevel((Component)logicalComponent);
    }

    public InterfaceDelegationSCtoLC(LogicalActor logicalActor) {
        this.computeComponentPairsForComponentFromLogicalLevel((Component)logicalActor);
    }

    public InterfaceDelegationSCtoLC(LogicalActorPkg logicalActorPck) {
        for (Component logicalActor : ActorPkgExt.getAllActors((LogicalActorPkg)logicalActorPck)) {
            this.computeComponentPairsForComponentFromLogicalLevel(logicalActor);
        }
    }

    public InterfaceDelegationSCtoLC(System systemComponent) {
        this.computeComponentPairsForComponentFromSystemLevel((Component)systemComponent);
    }

    public InterfaceDelegationSCtoLC(Actor actor) {
        this.computeComponentPairsForComponentFromSystemLevel((Component)actor);
    }

    public InterfaceDelegationSCtoLC(ActorPkg actorPck) {
        for (Component actor : ActorPkgExt.getAllActors((ActorPkg)actorPck)) {
            this.computeComponentPairsForComponentFromSystemLevel(actor);
        }
    }

    private void computeComponentPairsForComponentFromLogicalLevel(Component logicalComponent) {
        for (Component sourceComponent : logicalComponent.getAllocatedComponents()) {
            this.pairs.add(new AbstractMap.SimpleEntry<Component, Component>(sourceComponent, logicalComponent));
        }
    }

    private void computeComponentPairsForComponentFromSystemLevel(Component systemComponent) {
        for (Component targetComponent : systemComponent.getAllocatingComponents()) {
            this.pairs.add(new AbstractMap.SimpleEntry<Component, Component>(systemComponent, targetComponent));
        }
    }

    public void perform() {
        for (Map.Entry<Component, Component> pair : this.pairs) {
            this.perform(pair.getKey(), pair.getValue());
        }
    }

    protected void perform(Component source, Component target) {
        HashSet<Object> elementsToRemove = new HashSet<Object>();
        ArrayList<Interface> elementsToUnset = new ArrayList<Interface>();
        for (InterfaceImplementation interfaceImplementation : target.getImplementedInterfaceLinks()) {
            if (interfaceImplementation.getImplementedInterface() == null || source.getImplementedInterfaces().contains((Object)interfaceImplementation.getImplementedInterface()) || !this.areInSameLayer((EObject)interfaceImplementation.getImplementedInterface(), (EObject)source)) continue;
            elementsToRemove.add(interfaceImplementation);
        }
        for (InterfaceImplementation interfaceImplementation : source.getImplementedInterfaceLinks()) {
            if (interfaceImplementation.getImplementedInterface() == null) continue;
            ComponentExt.addImplementedInterface((Component)target, (Interface)interfaceImplementation.getImplementedInterface());
        }
        for (InterfaceUse interfaceUse : target.getUsedInterfaceLinks()) {
            if (interfaceUse.getUsedInterface() == null || source.getUsedInterfaces().contains((Object)interfaceUse.getUsedInterface()) || !this.areInSameLayer((EObject)interfaceUse.getUsedInterface(), (EObject)source)) continue;
            elementsToRemove.add(interfaceUse);
        }
        for (InterfaceUse interfaceUse : source.getUsedInterfaceLinks()) {
            if (interfaceUse.getUsedInterface() == null) continue;
            ComponentExt.addUsedInterface((Component)target, (Interface)interfaceUse.getUsedInterface());
        }
        for (Feature feature : source.getOwnedFeatures()) {
            if (!(feature instanceof ComponentPort)) continue;
            ComponentPort portSource = (ComponentPort)feature;
            ComponentPort portTarget = this.getRealizingComponentPort(portSource, target);
            for (Interface i : portTarget.getProvidedInterfaces()) {
                if (portSource.getProvidedInterfaces().contains((Object)i) || !this.areInSameLayer((EObject)i, (EObject)portSource)) continue;
                elementsToUnset.add(i);
            }
            for (Interface i : elementsToUnset) {
                portTarget.getProvidedInterfaces().remove((Object)i);
            }
            elementsToUnset.clear();
            for (Interface i : portTarget.getRequiredInterfaces()) {
                if (portSource.getRequiredInterfaces().contains((Object)i) || !this.areInSameLayer((EObject)i, (EObject)portSource)) continue;
                elementsToUnset.add(i);
            }
            for (Interface i : elementsToUnset) {
                portTarget.getRequiredInterfaces().remove((Object)i);
            }
            elementsToUnset.clear();
            for (Interface i : portSource.getProvidedInterfaces()) {
                if (portTarget.getProvidedInterfaces().contains((Object)i)) continue;
                portTarget.getProvidedInterfaces().add((Object)i);
            }
            for (Interface i : portSource.getRequiredInterfaces()) {
                if (portTarget.getRequiredInterfaces().contains((Object)i)) continue;
                portTarget.getRequiredInterfaces().add((Object)i);
            }
        }
        for (EObject eObject : elementsToRemove) {
            EcoreUtil.delete((EObject)eObject);
        }
    }

    private boolean areInSameLayer(EObject source, EObject target) {
        return CapellaLayerCheckingExt.areInSameLayer((EObject)source, (EObject)target);
    }

    public ComponentPort getRealizingComponentPort(ComponentPort port, Component target) {
        for (PortRealization realization : port.getIncomingPortRealizations()) {
            Port realizing = realization.getRealizingPort();
            if (realizing == null || !(realizing instanceof ComponentPort) || !realizing.eContainer().equals(target)) continue;
            return (ComponentPort)realizing;
        }
        ComponentPort cloned = FaFactory.eINSTANCE.createComponentPort();
        cloned.setOrientation(port.getOrientation());
        cloned.setKind(port.getKind());
        cloned.setName(port.getName());
        target.getOwnedFeatures().add((Object)cloned);
        PortRealization realization = InformationFactory.eINSTANCE.createPortRealization();
        realization.setSourceElement((TraceableElement)cloned);
        realization.setTargetElement((TraceableElement)port);
        cloned.getOwnedPortRealizations().add((Object)realization);
        return cloned;
    }
}

