/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces;

import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.ProjectionEngine;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceGenerationResult;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoEngine;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;
import org.polarsys.capella.core.tiger.impl.Transfo;
import org.polarsys.capella.core.tiger.impl.TransfoRule;

public class InterfaceGeneration
extends AbstractTransform {
    private static final String CAPELLA_INTERFACE_GENERATION_RULES = "org.polarsys.capella.core.projection.interfaces.generation";
    public static final String KEY_PREFS = "interfaceGenerationPreferences";
    public static final String KEY_DRY_RUN = "interfaceGenerationIsDryRun";
    public static final String KEY_RESULT = "interfaceGenerationResult";
    private final InterfaceGenerationPreferences prefs;
    private final boolean dryRun;
    private final InterfaceGenerationResult result;

    public InterfaceGeneration(InterfaceGenerationPreferences preferences, boolean dryRun) {
        this.prefs = preferences;
        this.dryRun = dryRun;
        this.result = new InterfaceGenerationResult(this.prefs);
    }

    public InterfaceGeneration() {
        this(new InterfaceGenerationPreferences(), false);
    }

    public static InterfaceGenerationPreferences getPreferences(ITransfo transfo) {
        InterfaceGenerationPreferences prefs = (InterfaceGenerationPreferences)transfo.get((Object)KEY_PREFS);
        if (prefs == null) {
            prefs = new InterfaceGenerationPreferences();
            transfo.put((Object)KEY_PREFS, (Object)prefs);
        }
        return prefs;
    }

    public static InterfaceGenerationResult getResult(ITransfo transfo) {
        InterfaceGenerationResult result = (InterfaceGenerationResult)transfo.get((Object)KEY_RESULT);
        if (result == null) {
            result = new InterfaceGenerationResult(InterfaceGeneration.getPreferences(transfo));
            transfo.put((Object)KEY_RESULT, (Object)result);
        }
        return result;
    }

    public void setContext(EObject context_p) {
        if (context_p instanceof Component || context_p instanceof ComponentPort) {
            this._context.add(context_p);
        }
    }

    protected ITransfo createTransfo(ITransfoRuleBase ruleBase_p) throws ClassNotFoundException {
        Iterator iterator = ruleBase_p.iterator();
        Transfo transfo = new Transfo(CapellacommonPackage.Literals.TRANSFO_LINK, CAPELLA_INTERFACE_GENERATION_RULES);
        while (iterator.hasNext()) {
            transfo.addRule((TransfoRule)iterator.next());
        }
        transfo.put((Object)"transfoSource", (Object)this._context);
        transfo.put((Object)KEY_PREFS, (Object)this.prefs);
        transfo.put((Object)KEY_DRY_RUN, (Object)this.dryRun);
        transfo.put((Object)KEY_RESULT, (Object)this.result);
        return transfo;
    }

    protected boolean retainContextElement(EObject contextElement, ITransfo transfo) {
        BlockArchitecture sourceBlock;
        if ((contextElement instanceof Component || contextElement instanceof ComponentPort) && (sourceBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement)) != null) {
            transfo.put((Object)"transfoSource", (Object)contextElement);
            transfo.put((Object)"transfoTargetContainer", (Object)sourceBlock);
            return true;
        }
        return false;
    }

    public static boolean isDryRun(ITransfo transfo) {
        return transfo.get((Object)KEY_DRY_RUN) == Boolean.TRUE;
    }

    public InterfaceGenerationResult getResult() {
        return this.result;
    }

    protected ITransfoEngine createTransfoEngine() {
        if (this.dryRun) {
            Logger quietLogger = Logger.getLogger((String)CAPELLA_INTERFACE_GENERATION_RULES);
            quietLogger.setAdditivity(false);
            quietLogger.setLevel(Level.OFF);
            return new ProjectionEngine(quietLogger);
        }
        return new ProjectionEngine();
    }
}

