/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceProvider;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceRequirer;

class ComponentPortInterfaceAdapter
implements InterfaceRequirer,
InterfaceProvider {
    private final ComponentPort port;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentPortInterfaceAdapter other = (ComponentPortInterfaceAdapter)obj;
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    ComponentPortInterfaceAdapter(ComponentPort port) {
        this.port = port;
    }

    @Override
    public Collection<FunctionInputPort> getFunctionInputPorts() {
        LinkedHashSet<FunctionInputPort> result = new LinkedHashSet<FunctionInputPort>();
        for (FunctionPort p : this.port.getAllocatedFunctionPorts()) {
            if (!(p instanceof FunctionInputPort)) continue;
            result.add((FunctionInputPort)p);
        }
        this.addFxPfromAllocatedFE(FaPackage.Literals.FUNCTIONAL_EXCHANGE__TARGET_FUNCTION_INPUT_PORT, result);
        return result;
    }

    @Override
    public Collection<FunctionOutputPort> getFunctionOutputPorts() {
        LinkedHashSet<FunctionOutputPort> result = new LinkedHashSet<FunctionOutputPort>();
        for (FunctionPort p : this.port.getAllocatedFunctionPorts()) {
            if (!(p instanceof FunctionOutputPort)) continue;
            result.add((FunctionOutputPort)p);
        }
        this.addFxPfromAllocatedFE(FaPackage.Literals.FUNCTIONAL_EXCHANGE__SOURCE_FUNCTION_OUTPUT_PORT, result);
        return result;
    }

    private <T> void addFxPfromAllocatedFE(EReference ref, Collection<T> result) {
        for (ComponentExchange ce : this.getComponentExchanges()) {
            for (FunctionalExchange allocated : ce.getAllocatedFunctionalExchanges()) {
                AbstractFunction fun;
                FunctionPort fxp = (FunctionPort)allocated.eGet((EStructuralFeature)ref);
                if (fxp == null || !(fxp.eContainer() instanceof AbstractFunction) || !(fun = (AbstractFunction)fxp.eContainer()).getAllocationBlocks().contains((Object)this.port.eContainer())) continue;
                result.add(fxp);
            }
        }
    }

    @Override
    public boolean addProvidedInterface(Interface iface) {
        return this.port.getProvidedInterfaces().add((Object)iface);
    }

    @Override
    public boolean addRequiredInterface(Interface iface) {
        return this.port.getRequiredInterfaces().add((Object)iface);
    }

    @Override
    public EObject getEObject() {
        return this.port;
    }

    @Override
    public String getText() {
        return EObjectLabelProviderHelper.getText((EObject)this.port);
    }

    @Override
    public Collection<ComponentExchange> getComponentExchanges() {
        return this.port.getComponentExchanges();
    }
}

