/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.TracingStrategy;

class ExchangeTracing
implements TracingStrategy {
    ExchangeTracing() {
    }

    @Override
    public Collection<Interface> getTracingInterfaces(InterfaceInfo info) {
        LinkedHashSet<Interface> candidates = new LinkedHashSet<Interface>();
        ArrayList<FunctionalExchange> targets = new ArrayList<FunctionalExchange>(info.getFunctionalExchanges());
        targets.addAll(info.getComponentExchanges());
        for (TraceableElement traceableElement : targets) {
            for (AbstractTrace t : traceableElement.getIncomingTraces()) {
                if (!(t instanceof TransfoLink) || !(t.getSourceElement() instanceof Interface)) continue;
                candidates.add((Interface)t.getSourceElement());
            }
        }
        return candidates;
    }

    private void traceTarget(Interface iface, TraceableElement target) {
        for (AbstractTrace t : target.getIncomingTraces()) {
            if (!(t instanceof TransfoLink) || t.getSourceElement() != iface) continue;
            return;
        }
        TransfoLink tl = CapellacommonFactory.eINSTANCE.createTransfoLink();
        tl.setSourceElement((TraceableElement)iface);
        tl.setTargetElement(target);
        iface.getOwnedTraces().add((Object)tl);
    }

    @Override
    public void traceInterface(Interface iface, InterfaceInfo info) {
        Collection<FunctionalExchange> targets = info.getFunctionalExchanges().size() > 0 ? info.getFunctionalExchanges() : info.getComponentExchanges();
        for (TraceableElement traceableElement : targets) {
            this.traceTarget(iface, traceableElement);
        }
    }
}

