/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalExchange;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class FunctionalExchange_Delegation
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)eObj;
            AbstractFunction parentSource = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)fe);
            AbstractFunction parentTarget = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)fe);
            if (parentSource != null && parentTarget != null) {
                boolean bDelegatedFE = false;
                if (parentSource.getOwnedFunctions().isEmpty() && parentTarget.getOwnedFunctions().isEmpty()) {
                    bDelegatedFE = true;
                }
                if (!bDelegatedFE) {
                    return ctx.createFailureStatus(new Object[]{this.getSourceTargetMessage(fe)});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private String getMessageNameFor(AbstractFunction af) {
        return EObjectLabelProviderHelper.getMetaclassLabel((EObject)af, (boolean)false);
    }

    private String getMessageNameFor(FunctionalExchange fe) {
        AbstractFunction srcFunc = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)fe);
        if (srcFunc instanceof OperationalActivity) {
            return "Interaction";
        }
        return EObjectLabelProviderHelper.getMetaclassLabel((EObject)fe, (boolean)false);
    }

    private String getSourceTargetMessage(FunctionalExchange fe) {
        String msg = "";
        AbstractFunction srcFunc = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)fe);
        AbstractFunction tarFunc = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)fe);
        msg = srcFunc.getOwnedFunctions().size() > 0 && tarFunc.getOwnedFunctions().size() > 0 ? "Both source and target of \"" + EObjectLabelProviderHelper.getText((EObject)fe) + "\" (" + this.getMessageNameFor(fe) + ") are not delegated to leaf " + this.getMessageNameFor(srcFunc) : (srcFunc.getOwnedFunctions().size() > 0 ? "The source of \"" + EObjectLabelProviderHelper.getText((EObject)fe) + "\" (" + this.getMessageNameFor(fe) + ") is not delegated to a leaf " + this.getMessageNameFor(srcFunc) : "The target of \"" + EObjectLabelProviderHelper.getText((EObject)fe) + "\" (" + this.getMessageNameFor(fe) + ") is not delegated to a leaf " + this.getMessageNameFor(srcFunc));
        return msg;
    }
}

