/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessGenModels
extends RecordingCommand {
    private Session session;
    private Collection<GenModel> genmodels;

    public ProcessGenModels(Session session, Collection<GenModel> genmodels) {
        super(session.getTransactionalEditingDomain());
        this.session = session;
        this.genmodels = genmodels;
    }

    protected void doExecute() {
        LinkedHashSet toDelete = Sets.newLinkedHashSet();
        for (GenModel genmodel : this.genmodels) {
            for (GenPackage genpackage : genmodel.getGenPackages()) {
                this.cleanupGenPackages(toDelete, genpackage);
                this.cleanupGenClasses(toDelete, genpackage);
            }
        }
        for (GenBase genFeature : toDelete) {
            this.session.getModelAccessor().eDelete((EObject)genFeature, this.session.getSemanticCrossReferencer());
        }
        for (GenModel genmodel : this.genmodels) {
            if (genmodel.reconcile()) continue;
            System.out.println("Genmodel reconcile was not successful");
        }
    }

    private void cleanupGenPackages(Set<GenBase> toDelete, GenPackage genpackage) {
        for (GenPackage subpackage : genpackage.getSubGenPackages()) {
            if (subpackage.getEcorePackage() != null && subpackage.getEcorePackage().getESuperPackage() != genpackage.getEcorePackage()) {
                toDelete.add((GenBase)subpackage);
                continue;
            }
            this.cleanupGenClasses(toDelete, subpackage);
        }
    }

    private void cleanupGenClasses(Set<GenBase> toDelete, GenPackage genpackage) {
        for (GenClass genclass : genpackage.getGenClasses()) {
            if (genclass.getEcoreClass() != null && genclass.getEcoreClass().getEPackage() != genpackage.getEcorePackage()) {
                toDelete.add((GenBase)genclass);
                continue;
            }
            for (GenFeature feat : genclass.getGenFeatures()) {
                if (feat.getEcoreFeature() == null || feat.getEcoreFeature().getEContainingClass() == feat.getGenClass().getEcoreClassifier()) continue;
                toDelete.add((GenBase)feat);
            }
        }
    }
}

