/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.dialog.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.Activator;

public class GeneralServices {
    private static final String iconPath = "obj16/searchView.gif";

    public static void refreshResultsAccordingToCriteria(SearchCriteria criteria, Table resultsTable, Shell shell) {
        resultsTable.removeAll();
        List modelsToLoad = ModelReuseHelper.findModelsAccordingToCriteria((SearchCriteria)criteria);
        if (modelsToLoad.size() >= 1) {
            for (Resource resource : modelsToLoad) {
                TableItem resourceItem = new TableItem(resultsTable, 0);
                resourceItem.setData((Object)GeneralServices.constructFullCriteriaFromResource(resource));
                if (resource.getVersion() != null && resource.getName() != null) {
                    resourceItem.setText(String.valueOf(resource.getName()) + " v" + resource.getVersion());
                } else if (resource.getName() != null) {
                    resourceItem.setText(resource.getName());
                } else {
                    resourceItem.setText(resource.getId());
                }
                resourceItem.setImage(GeneralServices.getParentImage());
            }
        }
    }

    public static boolean checkIfCurrentTagFitsWithModels(String tagValue, Shell shell) {
        SearchCriteria criteriaForTags = new SearchCriteria();
        criteriaForTags.getTags().add(tagValue);
        List modelsToLoad = ModelReuseHelper.findModelsAccordingToCriteria((SearchCriteria)criteriaForTags);
        if (modelsToLoad.isEmpty()) {
            MessageDialog dialog = new MessageDialog(shell, "Error during tags typing...", null, "Specified tag doesn't fit with a specific model ...", 2, new String[]{"OK"}, 0);
            dialog.open();
            return false;
        }
        return true;
    }

    public static void constructDialogForExistingTag(String tagValue, Shell shell) {
        MessageDialog dialog = new MessageDialog(shell, "Error during tags typing...", null, "Specified tag " + tagValue + " already exists", 4, new String[]{"OK"}, 0);
        dialog.open();
    }

    protected static SearchCriteria constructFullCriteriaFromResource(Resource resource) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setId(resource.getId());
        if (resource.getName() != null) {
            criteria.setName(resource.getName());
        }
        if (resource.getDomain() != null) {
            criteria.setDomain(resource.getDomain());
        }
        if (resource.getVersion() != null) {
            criteria.setVersion(resource.getVersion());
        }
        if (!resource.getTags().isEmpty()) {
            criteria.getTags().addAll(resource.getTags());
        }
        return criteria;
    }

    public static Image getParentImage() {
        Image image = Activator.getDefault().getImage(iconPath);
        return image;
    }

    public static List<StringValue> toStringValueList(List<String> tags) {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        for (String value : tags) {
            result.add(new StringValue(value));
        }
        return result;
    }

    public static class StringValue {
        public String value;

        public StringValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

