/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.gen.edit.decorators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.data.gen.edit.decorators.IDelegatedDecorator;

public class ItemProviderAdapterDecorator
extends ItemProviderDecorator
implements Adapter.Internal {
    private List<Notifier> targets;
    private static Map<String, List<IDelegatedDecorator>> _contributors = null;
    private static Map<IDelegatedDecorator, String> _contributorsPosition = null;
    private static final String PLUGIN_ID = "org.polarsys.capella.core.data.gen.edit.decorators";
    private static final String EXTENSION_POINT_ID = "delegatedDecorator";
    protected static final String DECORATOR_POSITION_OVERRIDES = "overrides";
    protected static final String DECORATOR_POSITION_PREFIX = "prefix";
    protected static final String DECORATOR_POSITION_SUFFIX = "suffix";

    public ItemProviderAdapterDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        String text = super.getText(object);
        for (IDelegatedDecorator labelProvider : this.getDelegatedDecorators((EObject)object)) {
            if (!labelProvider.appliesTo(object)) continue;
            String position = this.getDecoratorPosition(labelProvider);
            if (DECORATOR_POSITION_PREFIX.equals(position)) {
                text = String.valueOf(labelProvider.getText(object)) + text;
                continue;
            }
            if (DECORATOR_POSITION_SUFFIX.equals(position)) {
                text = String.valueOf(text) + labelProvider.getText(object);
                continue;
            }
            if (!DECORATOR_POSITION_OVERRIDES.equals(position)) continue;
            text = labelProvider.getText(object);
        }
        return text;
    }

    protected String getDecoratorPosition(IDelegatedDecorator labelProvider) {
        if (labelProvider == null) {
            return "";
        }
        if (_contributorsPosition == null) {
            this.fillContributorsCache();
        }
        return _contributorsPosition.get(labelProvider);
    }

    protected List<IDelegatedDecorator> getDelegatedDecorators(EObject eobject) {
        List<IDelegatedDecorator> providers;
        if (eobject == null) {
            return Collections.emptyList();
        }
        if (_contributors == null) {
            this.fillContributorsCache();
        }
        return (providers = _contributors.get(eobject.eClass().getInstanceClassName())) != null ? providers : Collections.emptyList();
    }

    private void fillContributorsCache() {
        _contributors = new HashMap<String, List<IDelegatedDecorator>>();
        _contributorsPosition = new HashMap<IDelegatedDecorator, String>();
        List<IConfigurationElement> attributesProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)PLUGIN_ID, (String)EXTENSION_POINT_ID));
        for (IConfigurationElement provider : attributesProvider) {
            String type = provider.getAttribute("type");
            List<IDelegatedDecorator> labelProviders = _contributors.get(type);
            if (labelProviders == null) {
                labelProviders = new ArrayList<IDelegatedDecorator>();
                _contributors.put(type, labelProviders);
            }
            IDelegatedDecorator cls = (IDelegatedDecorator)ExtensionPointHelper.createInstance((IConfigurationElement)provider, (String)"class");
            labelProviders.add(cls);
            String position = provider.getAttribute("position");
            _contributorsPosition.put(cls, position == null ? "" : position);
        }
    }

    protected AdapterFactory getRootAdapterFactory() {
        if (this.adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        }
        return this.adapterFactory;
    }

    protected Object overlayImage(Object object, Object image) {
        if (AdapterFactoryEditingDomain.isControlled((Object)object)) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/ControlledObject"));
            image = new ComposedImage(images);
        }
        return image;
    }

    public Notifier getTarget() {
        if (this.targets == null || this.targets.isEmpty()) {
            return null;
        }
        return this.targets.get(this.targets.size() - 1);
    }

    public void setTarget(Notifier newTarget) {
        if (this.targets == null) {
            this.targets = new ArrayList<Notifier>();
        }
        this.targets.add(newTarget);
    }

    public void unsetTarget(Notifier oldTarget) {
        if (this.targets != null) {
            this.targets.remove(oldTarget);
        }
    }
}

