/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.ocl.provider.generic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.validation.AccuracyPlugin;
import org.polarsys.kitalpha.validation.ocl.provider.generic.GenericOCLConstraintProvider;
import org.polarsys.kitalpha.validation.ocl.provider.generic.util.OCLConstraintDescriptor;
import org.polarsys.kitalpha.validation.ocl.provider.generic.util.ValidationInfo;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintFactory;

public class GenericOCLConstraintFactory
extends GenericConstraintFactory {
    private Category _commonCategory;
    private Category mandatoryCategory;
    private String _commonCategoryName;
    private ResourceBundle _configurationFileResourceBundle;
    private Bundle _contributorPluginBundle;
    private String _constraintsFolder;
    private GenericOCLConstraintProvider _provider;
    private List<OCLConstraintDescriptor> _createdConstraints = new LinkedList<OCLConstraintDescriptor>();

    public GenericOCLConstraintFactory(GenericOCLConstraintProvider provider) {
        super(provider);
        this._configurationFileResourceBundle = provider.getConfigurationFileResourceBundle();
        this._contributorPluginBundle = provider.getContributorBundle();
        this._constraintsFolder = this.getConstraintsFolder();
        this._commonCategoryName = this.getCommonConstraintCategory();
        this._commonCategory = CategoryManager.getInstance().getCategory(this._commonCategoryName);
        this._provider = provider;
    }

    private Category getMandatoryCategory() {
        if (this.mandatoryCategory == null) {
            this.mandatoryCategory = CategoryManager.getInstance().getCategory(String.valueOf(this._commonCategoryName) + "/mandatory");
            this.mandatoryCategory.setMandatory(true);
        }
        return this.mandatoryCategory;
    }

    private OCLConstraintDescriptor createConstraintDescriptor(String requirementId, String invariantId, Constraint invariant, String oclFileName, String constraintNamespace) {
        String invariantName = invariant.getName();
        invariant.setName(this.getName(oclFileName, invariantName));
        String constraintMessage = this.getMessage(oclFileName, invariantName);
        ConstraintSeverity constraintSeverity = this.toConstraintSeverity(this.getSeverity(oclFileName, invariantName));
        int constraintCode = this.toIntegerCode(this.getCode(oclFileName, invariantName));
        ValidationInfo myinfo = new ValidationInfo(constraintMessage, constraintSeverity);
        OCLConstraintDescriptor currentConstraintDescriptor = new OCLConstraintDescriptor(requirementId, invariantId, constraintNamespace, invariant, oclFileName, constraintCode, myinfo);
        return currentConstraintDescriptor;
    }

    @Override
    public List<AbstractConstraintDescriptor> createConstraints() {
        this._createdConstraints.clear();
        List<String> constraintFilesNames = this.getConstraintFilesNames();
        List<String> mandatoryRequirements = this.getMandatoryRequirements();
        for (String currentConstraintFileName : constraintFilesNames) {
            String path = String.valueOf(this._constraintsFolder) + currentConstraintFileName + ".ocl";
            if (path == null || path.length() <= 0) continue;
            this.createOCLConstraintsFromFile(path, mandatoryRequirements);
        }
        return new ArrayList<AbstractConstraintDescriptor>(this._createdConstraints);
    }

    private void createOCLConstraintsFromFile(String path, List<String> mandatoryRequirements) {
        Path ipath = new Path(path);
        String oclFileNameWithExtension = ipath.lastSegment();
        String oclFileName = oclFileNameWithExtension.replace("." + ipath.getFileExtension(), "");
        List<Constraint> localFileConstraints = this.loadConstraintsFromFile(path, this._contributorPluginBundle);
        for (Constraint constraint : localFileConstraints) {
            if (!this.isInvariant(constraint)) continue;
            String invariantName = constraint.getName();
            OCLConstraintDescriptor currentConstraintDescriptor = this.createConstraintDescriptor(oclFileName, invariantName, constraint, oclFileName, this._contributorPluginBundle.getSymbolicName());
            List<String> constraintCategories = this.getConstraintCategories(oclFileName, invariantName);
            this.associateConstaintToCategory(currentConstraintDescriptor, this._commonCategory);
            this.associateConstraintToCategories(currentConstraintDescriptor, constraintCategories);
            if (mandatoryRequirements.contains(oclFileName)) {
                this.associateConstaintToCategory(currentConstraintDescriptor, this.getMandatoryCategory());
            }
            this._createdConstraints.add(currentConstraintDescriptor);
        }
    }

    private List<String> getConstraintFilesNames() {
        String constraintFilesNames = this.getString("ConstraintFiles");
        ArrayList<String> constraintFilesNamesList = new ArrayList<String>();
        if (constraintFilesNames != null) {
            String[] constraintFilesArray;
            String[] stringArray = constraintFilesArray = constraintFilesNames.split(",");
            int n = constraintFilesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                constraintFilesNamesList.add(string);
                ++n2;
            }
            return constraintFilesNamesList;
        }
        System.out.println("[WARNING] No constraint file names were specified");
        return constraintFilesNamesList;
    }

    private String getConstraintsFolder() {
        return this.getString("ConstraintsFolder");
    }

    private String getString(String key) {
        try {
            return this._configurationFileResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private boolean isInvariant(Constraint constraint) {
        return "invariant".equals(constraint.getStereotype());
    }

    private List<Constraint> loadConstraintsFromFile(String oclFilePath, Bundle bundle) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        URL url = this._provider.getUrlFromPath(oclFilePath);
        if (url != null) {
            List list;
            InputStream input = url.openStream();
            try {
                OCLInput oclInput = new OCLInput(input);
                OCL ocl = OCL.newInstance();
                list = ocl.parse(oclInput);
            }
            catch (ParserException e) {
                try {
                    try {
                        AccuracyPlugin.getDefault().error("Failed to parse OCL constraints in " + bundle.getSymbolicName() + " for " + oclFilePath, (Exception)((Object)e));
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    AccuracyPlugin.getDefault().error("Failed to load OCL constraints from " + bundle.getSymbolicName(), e2);
                }
            }
            input.close();
            return list;
        }
        return constraints;
    }
}

