/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.contrib.unknownreference.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.feedback.Feedback;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IFeedback;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceNotFoundException;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;

public class MetadataUnknownReferencedViewpoint
implements IScrutinize<Set<ViewpointReference>, Collection<IFeedback.IFeedbackMessage>> {
    private Set<ViewpointReference> unusedViewpoints = new HashSet<ViewpointReference>();
    private final ResourceHelper resourceReuseHelper = ResourceReuse.createHelper();

    public void findIn(EObject arg0) {
    }

    public void findIn(Resource resource) {
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Metadata) {
            Metadata root = (Metadata)resource.getContents().get(0);
            for (ViewpointReference uv : root.getViewpointReferences()) {
                try {
                    this.resourceReuseHelper.getResource(uv.getVpId());
                }
                catch (ResourceNotFoundException e) {
                    this.unusedViewpoints.add(uv);
                }
            }
        }
    }

    public Set<ViewpointReference> getAnalysisResult() {
        return this.unusedViewpoints;
    }

    public Collection<IFeedback.IFeedbackMessage> getFeedbackAnalysisMessages() {
        Feedback feedback = new Feedback();
        for (ViewpointReference vr : this.unusedViewpoints) {
            feedback.addFeedbackMessage((IFeedback.IFeedbackMessage)new Feedback.FeedbackMessage(IFeedback.FeedbackLevel.ERROR, "Uninstalled viewpoint: " + vr.getVpId()));
        }
        return feedback.getFeedbackMessages();
    }
}

