/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalJavaService;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.ContextServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.ENodeServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.EObjectServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.PropertiesServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.RequestServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.ResourceServices;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.StringServices;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class AcceleoCompletionEntry {
    public static final Integer PROPOSAL = 0;
    public static final Integer DISPLAY = 1;
    public static final Integer INFORMATION = 2;
    protected static final char[] ACTIVATION_CHARACTERS = new char[]{' ', '\t', '\n', '|', '&', '=', '(', ',', '-', '+', '*', '/', '!', '{', '['};
    protected static final char[] PARENTHESIS = new char[]{'(', ')'};
    protected static final char[] BRACKETS = new char[]{'[', ']'};
    protected static final String COMMA = ", ";
    protected EObject element;
    private String metaClass = "";
    private String qualifier = "";
    private EPackage.Registry runtimeTypeRegistry = EPackage.Registry.INSTANCE;

    public List<ContentProposal> computeProposals(ContentContext context) {
        Collection targetTypes = context.getInterpreterContext().getTargetTypes();
        if (!context.getInterpreterContext().requiresTargetType()) {
            this.metaClass = "ecore.EObject";
        } else if (targetTypes.size() == 1) {
            this.metaClass = (String)targetTypes.iterator().next();
        }
        this.element = context.getInterpreterContext().getElement();
        Object[] proposals = this.computeMetamodelTypesProposals(this.getElementClassifierList(context.getInterpreterContext().getElement(), context.getContents()), context.getContents(), false);
        List<ContentProposal> contentsMap = this.computeResolvedTypesProposals(proposals, context.getContents(), context.getPosition());
        return this.deleteDuplicatedProposals(contentsMap);
    }

    public List<ContentProposal> computeProposals(ContentInstanceContext context) {
        Object[] proposals = this.computeMetamodelTypesProposals(this.getElementClassifierList(context.getCurrentSelected(), context.getTextSoFar()), context.getTextSoFar(), false);
        List<ContentProposal> contentsMap = this.computeResolvedTypesProposals(proposals, context.getTextSoFar(), context.getCursorPosition());
        return this.deleteDuplicatedProposals(contentsMap);
    }

    private List<EClassifier> getElementClassifierList(EObject eObject, String textSoFar) {
        ArrayList<EClassifier> eClassifiers = new ArrayList<EClassifier>();
        if (eObject != null && textSoFar.replace(" ", "").equals("<%%>") || textSoFar.replace(" ", "").equals("<%self%>")) {
            eClassifiers.addAll(this.getElementClassifierList(eObject.eClass()));
        } else {
            ArrayList values = new ArrayList(this.runtimeTypeRegistry.values());
            for (Object value : values) {
                try {
                    if (value instanceof EPackage) {
                        eClassifiers.addAll((Collection<EClassifier>)((EPackage)value).getEClassifiers());
                        continue;
                    }
                    if (!(value instanceof EPackage.Descriptor)) continue;
                    eClassifiers.addAll((Collection<EClassifier>)((EPackage.Descriptor)value).getEPackage().getEClassifiers());
                }
                catch (Throwable throwable) {}
            }
        }
        return eClassifiers;
    }

    private Set<EClass> getElementClassifierList(EClass eClass) {
        LinkedHashSet<EClass> eClassifiers = new LinkedHashSet<EClass>();
        eClassifiers.add(eClass);
        for (EClass superClass : eClass.getESuperTypes()) {
            if (eClassifiers.contains(superClass)) continue;
            eClassifiers.addAll(this.getElementClassifierList(superClass));
        }
        return eClassifiers;
    }

    private List<ContentProposal> deleteDuplicatedProposals(List<ContentProposal> contents) {
        ArrayList<ContentProposal> resultProposals = new ArrayList<ContentProposal>(contents.size());
        for (ContentProposal entry : contents) {
            if (resultProposals.contains(entry)) continue;
            resultProposals.add(entry);
        }
        Collections.sort(resultProposals);
        return resultProposals;
    }

    private EClassifier[] computeMetamodelTypesProposals(List<EClassifier> classes, String start, boolean classOnly) {
        TreeSet<EClassifier> classifiers = new TreeSet<EClassifier>(new Comparator<EClassifier>(){

            @Override
            public int compare(EClassifier c0, EClassifier c1) {
                return ETools.getEClassifierShortPath(c0).compareTo(ETools.getEClassifierShortPath(c1));
            }
        });
        Iterables.addAll(classifiers, classes);
        Iterator it = classifiers.iterator();
        while (it.hasNext()) {
            EClassifier eClassifier = (EClassifier)it.next();
            if (eClassifier.getName() != null) continue;
            it.remove();
        }
        classifiers.add((EClassifier)EcorePackage.eINSTANCE.getEObject());
        EClassifier[] proposals = classifiers.toArray(new EClassifier[classifiers.size()]);
        String[] replacementStrings = new String[proposals.length * 2];
        String[] displayStrings = new String[proposals.length * 2];
        String[] informationStrings = new String[proposals.length * 2];
        int[] cursorPositions = new int[proposals.length * 2];
        int i = 0;
        while (i < proposals.length) {
            EClassifier currentProposal = proposals[i];
            replacementStrings[i] = currentProposal.getName();
            cursorPositions[i] = replacementStrings[i].length();
            displayStrings[i] = currentProposal.getName();
            informationStrings[i] = AcceleoCompletionEntry.getDescription(currentProposal);
            int j = proposals.length + i;
            replacementStrings[j] = ETools.getEClassifierShortPath(currentProposal);
            cursorPositions[j] = replacementStrings[j].length();
            displayStrings[j] = replacementStrings[j];
            informationStrings[j] = informationStrings[i];
            ++i;
        }
        return proposals;
    }

    private List<ContentProposal> computeResolvedTypesProposals(Object[] proposal, String text, int offset) {
        String endStart = AcceleoCompletionEntry.extractEndStart(text, offset);
        Object[] proposals = this.getAllContents(proposal);
        String[] replacementStrings = new String[proposals.length];
        String[] displayStrings = new String[proposals.length];
        String[] informationStrings = new String[proposals.length];
        int[] cursorPositions = new int[proposals.length];
        int i = 0;
        while (i < replacementStrings.length) {
            replacementStrings[i] = null;
            if (proposals[i] instanceof Method) {
                AcceleoCompletionEntry.computeForMethod(proposals, replacementStrings, displayStrings, informationStrings, cursorPositions, i);
            } else if (proposals[i] instanceof EOperation) {
                AcceleoCompletionEntry.computeForEOperation(proposals, replacementStrings, displayStrings, informationStrings, cursorPositions, i);
            } else if (proposals[i] instanceof EAttribute) {
                AcceleoCompletionEntry.computeForEAttribute(proposals, replacementStrings, displayStrings, informationStrings, cursorPositions, i);
            } else if (proposals[i] instanceof EReference) {
                AcceleoCompletionEntry.computeForEReference(proposals, replacementStrings, displayStrings, informationStrings, cursorPositions, i);
            } else {
                replacementStrings[i] = proposals[i].toString();
                displayStrings[i] = proposals[i].toString();
                informationStrings[i] = proposals[i].toString();
                cursorPositions[i] = replacementStrings[i].length();
            }
            if (endStart.startsWith(TemplateConstants.FEATURE_BEGIN) && replacementStrings[i] != null) {
                replacementStrings[i] = String.valueOf(TemplateConstants.FEATURE_BEGIN) + replacementStrings[i];
                cursorPositions[i] = cursorPositions[i] + TemplateConstants.FEATURE_BEGIN.length();
            }
            ++i;
        }
        return this.computeValidProposals(proposals, replacementStrings, displayStrings, informationStrings, cursorPositions, endStart, offset);
    }

    private static void computeForMethod(Object[] proposals, String[] replacementStrings, String[] displayStrings, String[] informationStrings, int[] cursorPositions, int i) {
        Method method = (Method)proposals[i];
        StringBuilder replacementString = new StringBuilder(method.getName());
        replacementString.append('(');
        cursorPositions[i] = replacementString.length();
        StringBuilder displayString = new StringBuilder(method.getName());
        displayString.append(" (");
        Class<?>[] paramTypes = method.getParameterTypes();
        int j = 1;
        while (j < paramTypes.length) {
            Class<?> paramType = paramTypes[j];
            replacementString.append(EvalJavaService.getSimpleName(paramType));
            displayString.append(EvalJavaService.getSimpleName(paramType));
            if (j + 1 < paramTypes.length) {
                replacementString.append(COMMA);
                displayString.append(COMMA);
            }
            ++j;
        }
        replacementString.append(')');
        displayString.append(')');
        if (method.getReturnType() != null) {
            displayString.append(' ');
            displayString.append(EvalJavaService.getSimpleName(method.getReturnType()));
        }
        displayString.append(" - ");
        displayString.append(EvalJavaService.getSimpleName(method.getDeclaringClass()));
        replacementStrings[i] = replacementString.toString();
        displayStrings[i] = displayString.toString();
        informationStrings[i] = method.toString();
    }

    private static void computeForEAttribute(Object[] proposals, String[] replacementStrings, String[] displayStrings, String[] informationStrings, int[] cursorPositions, int i) {
        EAttribute attribute = (EAttribute)proposals[i];
        replacementStrings[i] = attribute.getName();
        cursorPositions[i] = replacementStrings[i] != null ? replacementStrings[i].length() : 0;
        String displayString = attribute.getName();
        if (attribute.getEType() != null) {
            displayString = String.valueOf(displayString) + " : " + attribute.getEType().getName();
        }
        displayStrings[i] = displayString;
        informationStrings[i] = displayString;
    }

    private static void computeForEReference(Object[] proposals, String[] replacementStrings, String[] displayStrings, String[] informationStrings, int[] cursorPositions, int i) {
        EReference reference = (EReference)proposals[i];
        replacementStrings[i] = reference.getName();
        cursorPositions[i] = replacementStrings[i] != null ? replacementStrings[i].length() : 0;
        String displayString = reference.getName();
        if (reference.getEType() != null) {
            int upperBound;
            int lowerBound = reference.getLowerBound();
            String bounds = lowerBound == (upperBound = reference.getUpperBound()) ? String.valueOf(lowerBound) : String.valueOf(lowerBound) + (upperBound != -1 ? ".." + upperBound : "..*");
            bounds = reference.isContainment() ? String.valueOf('[') + bounds + ']' : String.valueOf('{') + bounds + '}';
            displayStrings[i] = displayString = String.valueOf(displayString) + " : " + reference.getEType().getName() + ' ' + bounds;
            informationStrings[i] = displayString;
        }
    }

    private static void computeForEOperation(Object[] proposals, String[] replacementStrings, String[] displayStrings, String[] informationStrings, int[] cursorPositions, int i) {
        EOperation method = (EOperation)proposals[i];
        StringBuilder replacementString = new StringBuilder(method.getName());
        replacementString.append('(');
        cursorPositions[i] = replacementString.length();
        StringBuilder displayString = new StringBuilder(method.getName());
        displayString.append(" (");
        EList paramTypes = method.getETypeParameters();
        int j = 1;
        while (j < paramTypes.size()) {
            ETypeParameter paramType = (ETypeParameter)paramTypes.get(j);
            displayString.append(paramType.getName());
            if (j + 1 < paramTypes.size()) {
                replacementString.append(COMMA);
                displayString.append(COMMA);
            }
            ++j;
        }
        replacementString.append(')');
        displayString.append(')');
        replacementStrings[i] = replacementString.toString();
        displayStrings[i] = displayString.toString();
        informationStrings[i] = method.toString();
    }

    private List<ContentProposal> computeValidProposals(Object[] objects, String[] replacementStrings, String[] displayStrings, String[] informationStrings, int[] cursorPositions, String start, int offset) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String startToLowerCase = start.toLowerCase();
        int i = 0;
        while (i < replacementStrings.length) {
            String replacementString = replacementStrings[i];
            if (replacementString != null) {
                String displayString = displayStrings[i];
                String informationString = informationStrings[i];
                String replacementStringL = replacementString.toLowerCase();
                if (start.length() == 0 || replacementStringL.startsWith(startToLowerCase) || replacementStringL.indexOf(String.valueOf(TemplateConstants.LINK_PREFIX_SEPARATOR) + (startToLowerCase.startsWith(TemplateConstants.FEATURE_BEGIN) ? startToLowerCase.substring(TemplateConstants.FEATURE_BEGIN.length()) : startToLowerCase)) > -1) {
                    proposals.add(new ContentProposal(replacementString.replaceFirst(TemplateConstants.FEATURE_BEGIN, ""), displayString, informationString));
                }
            }
            ++i;
        }
        proposals.trimToSize();
        return proposals;
    }

    private Object[] getAllContents(Object[] proposals) {
        Method newProposal;
        Object[] newProposals = null;
        Method[] allMethodsTab = null;
        ArrayList contents = Lists.newArrayList();
        this.addModelElements(proposals, contents);
        allMethodsTab = EObjectServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        Method[] methodArray = newProposals;
        int n = newProposals.length;
        int n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = ContextServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = ENodeServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = PropertiesServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = RequestServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = StringServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        allMethodsTab = ResourceServices.class.getDeclaredMethods();
        newProposals = this.getPublicMethod(allMethodsTab);
        methodArray = newProposals;
        n = newProposals.length;
        n2 = 0;
        while (n2 < n) {
            newProposal = methodArray[n2];
            contents.add(newProposal);
            ++n2;
        }
        newProposals = contents.toArray();
        return newProposals;
    }

    protected void addModelElements(Object[] proposals, List<Object> contents) {
        EClassifier classifier = null;
        EClass current = null;
        Object[] objectArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            Object proposal2 = objectArray[n2];
            classifier = (EClassifier)proposal2;
            if (classifier instanceof EClass) {
                current = (EClass)classifier;
                if (this.metaClass != null && classifier.getName().equals(this.metaClass) && (this.qualifier == null || current.getEPackage().getNsURI().contains(this.qualifier))) {
                    contents.clear();
                    contents.addAll((Collection<Object>)current.getEAllAttributes());
                    contents.addAll((Collection<Object>)current.getEAllReferences());
                    break;
                }
                contents.addAll((Collection<Object>)current.getEAllAttributes());
                contents.addAll((Collection<Object>)current.getEAllReferences());
            }
            ++n2;
        }
    }

    private Method[] getPublicMethod(Method[] tab) {
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        Method[] methodArray = tab;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            Method element2 = methodArray[n2];
            if (element2.getModifiers() == 1) {
                publicMethods.add(element2);
            }
            ++n2;
        }
        publicMethods.trimToSize();
        Method[] methods = new Method[publicMethods.size()];
        int i = 0;
        while (i < methods.length) {
            methods[i] = (Method)publicMethods.get(i);
            ++i;
        }
        return methods;
    }

    private static String extractEndStart(String text, int offset) {
        Int2 iSep;
        String extractStart = AcceleoCompletionEntry.extractStart(text, offset);
        Int2 iBracket = AcceleoCompletionEntry.getLastIndexOfOpenBracket(extractStart, (iSep = TextSearch.getDefaultSearch().lastIndexOf(extractStart, TemplateConstants.CALL_SEP, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION)).e() == -1 ? 0 : iSep.e());
        String endStart = iBracket.e() > -1 ? extractStart.substring(iBracket.e()) : (iSep.e() > -1 ? extractStart.substring(iSep.e()) : extractStart);
        return endStart;
    }

    private static Int2 getLastIndexOfOpenBracket(String extractStart, int start) {
        Int2 end = TextSearch.getDefaultSearch().lastIndexOf(extractStart, TemplateConstants.BRACKETS[1], start, TemplateConstants.SPEC, new String[][]{TemplateConstants.LITERAL});
        Int2 begin = TextSearch.getDefaultSearch().lastIndexOf(extractStart, TemplateConstants.BRACKETS[0], end.e() == -1 ? start : end.e(), TemplateConstants.SPEC, new String[][]{TemplateConstants.LITERAL});
        if (begin.b() > -1) {
            return begin;
        }
        return Int2.NOT_FOUND;
    }

    private static String extractStart(String originalText, int originalOffset) {
        if (originalOffset <= originalText.length()) {
            int offset;
            String text = "  " + originalText;
            int i = offset = "  ".length() + originalOffset;
            while (i >= 2) {
                int level;
                char c = text.charAt(i - 1);
                if (TemplateConstants.FEATURE_BEGIN.equals(text.substring(i - TemplateConstants.FEATURE_BEGIN.length(), i))) {
                    return String.valueOf(TemplateConstants.FEATURE_BEGIN) + text.substring(i, offset);
                }
                if (c == PARENTHESIS[1]) {
                    level = 0;
                    do {
                        if ((c = text.charAt(--i - 1)) == '\"') {
                            while (((c = text.charAt(--i - 1)) != '\"' || i >= 2 && text.charAt(i - 2) == '\\') && i > 1) {
                            }
                            continue;
                        }
                        if (c == PARENTHESIS[1]) {
                            ++level;
                            continue;
                        }
                        if (c != PARENTHESIS[0]) continue;
                        if (level == 0) break;
                        --level;
                    } while (i > 1);
                } else if (c == BRACKETS[1]) {
                    level = 0;
                    do {
                        if ((c = text.charAt(--i - 1)) == '\"') {
                            while (((c = text.charAt(--i - 1)) != '\"' || i >= 2 && text.charAt(i - 2) == '\\') && i > 1) {
                            }
                            continue;
                        }
                        if (c == BRACKETS[1]) {
                            ++level;
                            continue;
                        }
                        if (c != BRACKETS[0]) continue;
                        if (level == 0) break;
                        --level;
                    } while (i > 1);
                } else {
                    char[] cArray = ACTIVATION_CHARACTERS;
                    int n = ACTIVATION_CHARACTERS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char element2 = cArray[n2];
                        if (c == element2) {
                            return text.substring(i, offset);
                        }
                        ++n2;
                    }
                }
                --i;
            }
        }
        return "";
    }

    private static String getDescription(EClassifier eClassifier) {
        String desc = null;
        EAnnotation eAnno = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        if (eAnno != null) {
            desc = (String)eAnno.getDetails().get((Object)"documentation");
        }
        if (desc == null) {
            desc = eClassifier.getName();
        }
        return desc;
    }
}

