/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.business.internal.interpreter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.query.legacy.AcceleoInterpreterPlugin;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.AcceleoExtendedInterpreter;
import org.eclipse.sirius.query.legacy.business.internal.interpreter.CustomSystemServicesFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxExceptions;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalJavaService;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.JavaServiceNotFoundException;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.SystemServicesFactory;

public class SmartSpecificScript
extends SpecificScript {
    protected static final String INVERSE_KEYWORD = "~";
    private final AcceleoExtendedInterpreter interpreter;
    private ECrossReferenceAdapter crossReferencer;
    private final List<File> representationDescriptionFiles;

    public SmartSpecificScript(File file, AcceleoExtendedInterpreter interpreter) {
        super(file);
        this.interpreter = interpreter;
        this.representationDescriptionFiles = new ArrayList<File>();
    }

    public SmartSpecificScript(File moreSpecificRepresentationDescriptionFile, List<File> representationDescriptionFiles, AcceleoExtendedInterpreter interpreter) {
        super(moreSpecificRepresentationDescriptionFile);
        this.interpreter = interpreter;
        this.representationDescriptionFiles = representationDescriptionFiles;
    }

    @Override
    protected SystemServicesFactory createSystemServicesFactory() {
        return new CustomSystemServicesFactory();
    }

    @Override
    public ENode eGet(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager mode, boolean recursiveSearch) throws FactoryException, ENodeException {
        String name = call.getLink();
        ENode result = this.interpreter.getFromCache(node, name, args);
        if (result == null && (result = super.eGet(call, node, args, mode, recursiveSearch)) != null) {
            this.interpreter.cache(node, name, args, result);
        }
        return result;
    }

    @Override
    public ENode eGetTemplate(ENode node, String name, ENode[] args, LaunchManager mode) throws ENodeException, FactoryException {
        ENode result = null;
        if (name.startsWith("$")) {
            if (this.interpreter.isVariableSet(name.substring(1))) {
                return this.interpreter.getVariableValue(name.substring(1));
            }
            throw new FactoryException("Variable " + name.substring(1) + " not found");
        }
        try {
            if (name.startsWith(INVERSE_KEYWORD) && node.isEObject()) {
                result = this.getInverseReference(node, name);
            }
        }
        catch (ENodeCastException e1) {
            AcceleoInterpreterPlugin.getDefault().error("Error trying to resolve inverse references", e1);
        }
        if (result == null && node.isEObject()) {
            try {
                EObject cur = node.getEObject();
                if (this.interpreter.accessor != null && this.interpreter.accessor.eValid(cur, name)) {
                    Object res = this.interpreter.accessor.eGet(cur, name);
                    result = ENode.createTry(res, node);
                }
            }
            catch (ENodeCastException e) {
                AcceleoInterpreterPlugin.getDefault().error("Error trying to get metamodel extensions.", e);
            }
            catch (FeatureNotFoundException e) {
                AcceleoInterpreterPlugin.getDefault().error("Error accessing metamodel extensions.", e);
            }
        }
        if (result == null) {
            result = super.eGetTemplate(node, name, args, mode);
        }
        return result;
    }

    private ENode getInverseReference(ENode node, String name) throws ENodeCastException {
        ENode result = null;
        if (this.crossReferencer != null) {
            Collection settings = this.crossReferencer.getInverseReferences(node.getEObject());
            String inverseName = null;
            if (name.length() > INVERSE_KEYWORD.length()) {
                inverseName = name.substring(INVERSE_KEYWORD.length());
            }
            HashSet<EObject> referencing = new HashSet<EObject>(settings.size());
            for (EStructuralFeature.Setting setting : settings) {
                if (inverseName == null) {
                    referencing.add(setting.getEObject());
                    continue;
                }
                if (!setting.getEStructuralFeature().getName().equals(inverseName)) continue;
                referencing.add(setting.getEObject());
            }
            result = ENode.createTry(referencing, node);
        }
        return result;
    }

    public void setCrossReferencer(ECrossReferenceAdapter referencer) {
        this.crossReferencer = referencer;
    }

    @Override
    public void reset() throws TemplateSyntaxExceptions {
        super.reset();
        this.file = null;
    }

    @Override
    public void reset(String content) throws TemplateSyntaxExceptions {
        super.reset(content);
        this.file = null;
    }

    @Override
    protected File resolveScriptFile(File script, String importValue, String extension) {
        File result = null;
        for (File odesignFile : this.representationDescriptionFiles) {
            result = super.resolveScriptFile(odesignFile, importValue, extension);
            if (result != null) break;
        }
        return result;
    }

    @Override
    protected void addImportForJavaService(File file, String value) throws JavaServiceNotFoundException {
        boolean javaServiceFound = false;
        StringBuffer errorMessage = new StringBuffer("");
        for (File odesignFile : this.representationDescriptionFiles) {
            try {
                this.addImport(new EvalJavaService(odesignFile, value));
                javaServiceFound = true;
            }
            catch (JavaServiceNotFoundException e) {
                errorMessage.append(e.getMessage());
                errorMessage.append("\n");
            }
            if (javaServiceFound) break;
        }
        if (!javaServiceFound) {
            if (errorMessage.length() == 0) {
                throw new JavaServiceNotFoundException("no representation description files found so " + value + "could not be de found");
            }
            throw new JavaServiceNotFoundException(errorMessage.substring(0, errorMessage.length() - 1));
        }
    }
}

