/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.DefaultScriptLoader;
import org.eclipse.sirius.query.legacy.gen.template.scripts.EmptyScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IEvalSettings;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScriptLoader;
import org.eclipse.sirius.query.legacy.gen.template.scripts.SpecificScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalJavaService;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalModel;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services.SystemServicesFactory;

public abstract class AbstractScript
implements IScript {
    public static final String SCRIPT_LOADER_EXTENSION_ID = "org.eclipse.sirius.query.legacy.gen.scriptloader";
    protected Set imports = new TreeSet(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof EvalModel) && arg1 instanceof EvalModel) {
                return -1;
            }
            return 1;
        }
    });
    private SystemServicesFactory systemServicesFactory = null;
    private IScript[] goToSpecifics = null;
    protected IScript specific = null;
    private final Map context = new HashMap();
    private static IScriptLoader scriptLoader = null;

    @Override
    public ENode eGet(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager mode, boolean recursiveSearch) throws FactoryException, ENodeException {
        ENode eval;
        for (IEvalSettings anImport : this.imports) {
            if (!(anImport instanceof EvalJavaService) || !recursiveSearch && ((EvalJavaService)anImport).hasScriptContext() || !anImport.validateCall(call)) continue;
            ((EvalJavaService)anImport).setMode(1);
            ENode sub = anImport.eGet(call, node, args, mode, false);
            if (sub != null) {
                return sub;
            }
            ((EvalJavaService)anImport).setMode(2);
            sub = anImport.eGet(call, node, args, mode, false);
            if (sub == null) continue;
            return sub;
        }
        if (this.validateCall(call)) {
            if (node.isEObject()) {
                eval = this.eGetTemplate(node, call.getLink(), args, mode);
            } else if (node.isList()) {
                boolean found = false;
                ENodeList res = new ENodeList();
                try {
                    if (node.getList().size() == 0 && recursiveSearch) {
                        found = true;
                    }
                    ENodeIterator it = node.getList().iterator();
                    while (it.hasNext()) {
                        ENode child = this.eGet(call, it.next(), args, mode, recursiveSearch);
                        if (child == null) continue;
                        found = true;
                        res.add(child);
                    }
                }
                catch (ENodeCastException eNodeCastException) {}
                eval = found ? new ENode(res, node) : null;
            } else {
                eval = null;
            }
        } else {
            eval = null;
        }
        if (eval == null) {
            if (recursiveSearch) {
                for (IEvalSettings anImport : this.imports) {
                    if (!anImport.validateCall(call)) continue;
                    if (anImport instanceof SpecificScript) {
                        ENode sub = ((SpecificScript)anImport).eGetTemplate(node, call.getLink(), args, mode);
                        if (sub == null) continue;
                        return sub;
                    }
                    if (anImport instanceof EvalJavaService) {
                        ((EvalJavaService)anImport).setMode(0);
                        ENode sub = anImport.eGet(call, node, args, mode, false);
                        if (sub == null) continue;
                        return sub;
                    }
                    if (anImport instanceof EvalModel && (TemplateConstants.LINK_PREFIX_METAMODEL.equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_METAMODEL_SHORT.equals(call.getPrefix()))) {
                        if (node.isEObject()) {
                            ENode sub = anImport.eGet(call, node, args, mode, false);
                            if (sub == null) continue;
                            return sub;
                        }
                        if (node.isList()) {
                            boolean found = false;
                            ENodeList res = new ENodeList();
                            try {
                                if (node.getList().size() == 0 && recursiveSearch) {
                                    found = true;
                                }
                                ENodeIterator it = node.getList().iterator();
                                while (it.hasNext()) {
                                    ENode next = it.next();
                                    ENode child = anImport.eGet(call, next, args, mode, false);
                                    if (child == null) continue;
                                    found = true;
                                    res.add(child);
                                }
                            }
                            catch (ENodeCastException eNodeCastException) {}
                            if (!found) continue;
                            return new ENode(res, node);
                        }
                        ENode sub = anImport.eGet(call, node, args, mode, false);
                        if (sub == null) continue;
                        return sub;
                    }
                    ENode sub = anImport.eGet(call, node, args, mode, false);
                    if (sub == null) continue;
                    return sub;
                }
            } else {
                for (IEvalSettings anImport : this.imports) {
                    ENode sub;
                    if (anImport instanceof AbstractScript && !(anImport instanceof SpecificScript) && !(anImport instanceof EmptyScript) && anImport.validateCall(call)) {
                        sub = anImport.eGet(call, node, args, mode, false);
                        if (sub == null) continue;
                        return sub;
                    }
                    if (!(anImport instanceof EvalJavaService) || ((EvalJavaService)anImport).hasScriptContext() || !anImport.validateCall(call)) continue;
                    ((EvalJavaService)anImport).setMode(0);
                    sub = anImport.eGet(call, node, args, mode, false);
                    if (sub == null) continue;
                    return sub;
                }
            }
        }
        if (eval == null && node.isNull()) {
            return node;
        }
        return eval;
    }

    public abstract ENode eGetTemplate(ENode var1, String var2, ENode[] var3, LaunchManager var4) throws ENodeException, FactoryException;

    @Override
    public void addImport(IEvalSettings element) {
        if (element != null) {
            this.imports.add(element);
        }
    }

    @Override
    public void removeImport(IEvalSettings element) {
        if (element != null) {
            this.imports.remove(element);
        }
    }

    @Override
    public void clearImports() {
        this.imports.clear();
    }

    public Set getImports() {
        return this.imports;
    }

    protected SystemServicesFactory getSystemServicesFactory() {
        if (this.systemServicesFactory == null) {
            this.systemServicesFactory = this.createSystemServicesFactory();
        }
        return this.systemServicesFactory;
    }

    protected SystemServicesFactory createSystemServicesFactory() {
        return new SystemServicesFactory();
    }

    @Override
    public IScript[] goToSpecifics() {
        if (this.goToSpecifics == null && AbstractScript.getScriptLoader() != null) {
            this.goToSpecifics = AbstractScript.getScriptLoader().goToSpecifics(this);
        }
        return this.goToSpecifics;
    }

    @Override
    public IScript getSpecific() {
        return this.specific;
    }

    @Override
    public void setSpecific(IScript specific) {
        this.specific = specific;
        this.goToSpecifics = null;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public Object contextPeek(Object key) {
        Stack stack = (Stack)this.context.get(key);
        if (stack != null && !stack.isEmpty()) {
            Object result = stack.peek();
            if (result instanceof ENode) {
                return ((ENode)result).copy();
            }
            if (result instanceof ENode[]) {
                ENode[] copy = new ENode[((ENode[])result).length];
                int i = 0;
                while (i < copy.length) {
                    copy[i] = ((ENode[])result)[i].copy();
                    ++i;
                }
                return copy;
            }
            return result;
        }
        return null;
    }

    @Override
    public Object contextAt(Object key, int index) {
        Stack stack = (Stack)this.context.get(key);
        if (stack != null) {
            if (index >= 0 && index < stack.size()) {
                Object result = stack.elementAt(stack.size() - index - 1);
                if (result instanceof ENode) {
                    return ((ENode)result).copy();
                }
                if (result instanceof ENode[]) {
                    ENode[] copy = new ENode[((ENode[])result).length];
                    int i = 0;
                    while (i < copy.length) {
                        copy[i] = ((ENode[])result)[i].copy();
                        ++i;
                    }
                    return copy;
                }
                return result;
            }
            return null;
        }
        return null;
    }

    @Override
    public void contextPush(Object key, Object value) {
        Stack<Object> stack = (Stack<Object>)this.context.get(key);
        if (stack == null) {
            stack = new Stack<Object>();
            this.context.put(key, stack);
        }
        stack.push(value);
    }

    @Override
    public void contextPop(Object key) {
        Stack stack = (Stack)this.context.get(key);
        if (stack != null) {
            stack.pop();
        }
    }

    public Object resolveType(Object type, TemplateCallExpression call) {
        return this.resolveType(type, call, 0);
    }

    @Override
    public Object resolveType(Object type, TemplateCallExpression call, int depth) {
        if (depth < 1) {
            for (IEvalSettings anImport : this.imports) {
                Object resolvedType;
                if (!anImport.validateCall(call) || (resolvedType = anImport.resolveType(type, call, 1)) == null) continue;
                return resolvedType;
            }
        }
        if (call.getLink().equals(TemplateConstants.LINK_NAME_INDEX) && call.getFirstArgument() == null && "".equals(call.getPrefix())) {
            return IEvalSettings.GENERIC_TYPE;
        }
        if (call.getLink().equals(TemplateConstants.LINK_NAME_ARGS) && call.getArguments() != null && call.getArguments().size() == 1 && "".equals(call.getPrefix())) {
            return IEvalSettings.GENERIC_TYPE;
        }
        return null;
    }

    public Object[] getCompletionProposals(Object type) {
        return this.getCompletionProposals(type, 0);
    }

    @Override
    public Object[] getCompletionProposals(Object type, int depth) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (depth < 1) {
            TreeSet orderedImports = new TreeSet(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof EvalModel && !(arg1 instanceof EvalModel)) {
                        return -1;
                    }
                    return 1;
                }
            });
            orderedImports.addAll(this.imports);
            for (IEvalSettings anImport : orderedImports) {
                result.addAll(Arrays.asList(anImport.getCompletionProposals(type, 1)));
            }
        }
        return result.toArray();
    }

    public String toString() {
        StringBuffer text = new StringBuffer("");
        text.append(TemplateConstants.IMPORT_BEGIN);
        text.append('\n');
        for (IEvalSettings anImport : this.imports) {
            String importValue;
            if (!(anImport instanceof EvalModel) || (importValue = ((EvalModel)anImport).getUri()).length() <= 0) continue;
            text.append(TemplateConstants.MODELTYPE_WORD);
            text.append(' ');
            text.append(importValue);
            text.append('\n');
        }
        text.append(TemplateConstants.IMPORT_END);
        text.append("\n\n");
        return text.toString();
    }

    protected static IScriptLoader getScriptLoader() {
        if (scriptLoader == null) {
            return new DefaultScriptLoader();
        }
        return scriptLoader;
    }
}

