/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.ui.Activator;
import org.polarsys.kitalpha.cadence.ui.internal.widgets.CadenceItem;

public class CadenceTab
extends AbstractLaunchConfigurationTab {
    Map<String, Map<String, GenericParameter<?>>> _map = new HashMap();
    Map<String, CadenceItem> g = new HashMap<String, CadenceItem>();
    protected Text description = null;
    IConfigurationElement[] workflowElements = null;
    String workflow = "";

    public CadenceTab(String workflow) {
        this.workflow = workflow;
        this.workflowElements = CadenceRegistry.getAllWorkflowElement((String)workflow);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topLayout.numColumns = 1;
        topLayout.marginTop = 10;
        topLayout.marginBottom = 10;
        topLayout.marginLeft = 10;
        topLayout.marginRight = 10;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.createContents(comp);
        this.initialize();
    }

    public void createContents(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 2560);
        tabFolder.setSimple(false);
        GridData gd = new GridData(1808);
        tabFolder.setLayoutData((Object)gd);
        this.workflowElements = this.sort(this.workflowElements);
        int i = this.workflowElements.length - 1;
        while (i > -1) {
            IConfigurationElement elt = this.workflowElements[i];
            String wk_element_id = CadenceRegistry.getIdentifier((IConfigurationElement)elt);
            String wk_element_name = CadenceRegistry.getName((IConfigurationElement)elt);
            String wk_element_description = CadenceRegistry.getDescription((IConfigurationElement)elt);
            CadenceItem widget = new CadenceItem(tabFolder, elt, this.workflow, wk_element_id, wk_element_name, wk_element_description, this);
            this.g.put(wk_element_id, widget);
            --i;
        }
        tabFolder.setSelection(0);
    }

    private IConfigurationElement[] sort(IConfigurationElement[] workflowElements) {
        TreeMap<Integer, IConfigurationElement> l = new TreeMap<Integer, IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = workflowElements;
        int n = workflowElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            String order = CadenceRegistry.getOrderNumber((IConfigurationElement)elt);
            if (order == null) {
                order = "1000" + elt.hashCode();
            }
            l.put(new Integer(order) + elt.hashCode(), elt);
            ++n2;
        }
        return l.values().toArray(workflowElements);
    }

    protected void initialize() {
    }

    public String getName() {
        return "Cadence";
    }

    public Image getImage() {
        String img = "icons/cadence.png";
        ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"org.polarsys.kitalpha.cadence.ui", (String)img);
        return descriptor.createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            Map map = configuration.getAttribute("paramActivities", new HashMap());
            this.setParameters(map);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setParameters(Map<String, String> restore) {
        for (String wkElt : restore.keySet()) {
            CadenceItem widget = this.g.get(wkElt);
            String acs = restore.get(wkElt);
            widget.setParameters(acs);
        }
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> save1 = new HashMap<String, String>();
        for (String wkElt : this.g.keySet()) {
            String parameters = this.g.get(wkElt).getParameters();
            save1.put(wkElt, parameters);
        }
        return save1;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("paramActivities", this.getParameters());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setContainer(null);
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }

    public void setDescription(String message) {
        this.description.clearSelection();
        this.description.setText(message);
    }

    public Shell getShell() {
        return super.getShell();
    }

    protected void createDescription(Composite parent) {
        this.description = new Text(parent, 2570);
        this.description.setVisible(false);
        this.description.setBackground(Display.getDefault().getSystemColor(15));
        this.description.setForeground(Display.getDefault().getSystemColor(2));
        this.description.setToolTipText("Description");
        GridData gd = new GridData();
        gd.heightHint = 40;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        this.description.setLayoutData((Object)gd);
    }
}

