/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.epbs.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EPBSArchitecturePkg;
import org.polarsys.capella.core.data.epbs.EPBSContext;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.epbs.impl.ConfigurationItemImpl;
import org.polarsys.capella.core.data.epbs.impl.ConfigurationItemPkgImpl;
import org.polarsys.capella.core.data.epbs.impl.EPBSArchitectureImpl;
import org.polarsys.capella.core.data.epbs.impl.EPBSArchitecturePkgImpl;
import org.polarsys.capella.core.data.epbs.impl.EPBSContextImpl;
import org.polarsys.capella.core.data.epbs.impl.PhysicalArchitectureRealizationImpl;
import org.polarsys.capella.core.data.epbs.impl.PhysicalArtifactRealizationImpl;

public class EpbsFactoryImpl
extends EFactoryImpl
implements EpbsFactory {
    public static EpbsFactory init() {
        try {
            EpbsFactory theEpbsFactory = (EpbsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/core/epbs/1.2.0");
            if (theEpbsFactory != null) {
                return theEpbsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EpbsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createEPBSArchitecturePkg();
            }
            case 1: {
                return this.createEPBSArchitecture();
            }
            case 2: {
                return this.createEPBSContext();
            }
            case 3: {
                return this.createConfigurationItemPkg();
            }
            case 4: {
                return this.createConfigurationItem();
            }
            case 5: {
                return this.createPhysicalArchitectureRealization();
            }
            case 6: {
                return this.createPhysicalArtifactRealization();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createConfigurationItemKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertConfigurationItemKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public EPBSArchitecturePkg createEPBSArchitecturePkg() {
        EPBSArchitecturePkgImpl epbsArchitecturePkg = new EPBSArchitecturePkgImpl();
        epbsArchitecturePkg.setId(IdGenerator.createId());
        return epbsArchitecturePkg;
    }

    @Override
    public EPBSArchitecture createEPBSArchitecture() {
        EPBSArchitectureImpl epbsArchitecture = new EPBSArchitectureImpl();
        epbsArchitecture.setId(IdGenerator.createId());
        return epbsArchitecture;
    }

    @Override
    public EPBSContext createEPBSContext() {
        EPBSContextImpl epbsContext = new EPBSContextImpl();
        epbsContext.setId(IdGenerator.createId());
        return epbsContext;
    }

    @Override
    public ConfigurationItemPkg createConfigurationItemPkg() {
        ConfigurationItemPkgImpl configurationItemPkg = new ConfigurationItemPkgImpl();
        configurationItemPkg.setId(IdGenerator.createId());
        return configurationItemPkg;
    }

    @Override
    public ConfigurationItem createConfigurationItem() {
        ConfigurationItemImpl configurationItem = new ConfigurationItemImpl();
        configurationItem.setId(IdGenerator.createId());
        return configurationItem;
    }

    @Override
    public PhysicalArchitectureRealization createPhysicalArchitectureRealization() {
        PhysicalArchitectureRealizationImpl physicalArchitectureRealization = new PhysicalArchitectureRealizationImpl();
        physicalArchitectureRealization.setId(IdGenerator.createId());
        return physicalArchitectureRealization;
    }

    @Override
    public PhysicalArtifactRealization createPhysicalArtifactRealization() {
        PhysicalArtifactRealizationImpl physicalArtifactRealization = new PhysicalArtifactRealizationImpl();
        physicalArtifactRealization.setId(IdGenerator.createId());
        return physicalArtifactRealization;
    }

    public ConfigurationItemKind createConfigurationItemKindFromString(EDataType eDataType, String initialValue) {
        ConfigurationItemKind result = ConfigurationItemKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertConfigurationItemKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public EpbsPackage getEpbsPackage() {
        return (EpbsPackage)this.getEPackage();
    }

    @Deprecated
    public static EpbsPackage getPackage() {
        return EpbsPackage.eINSTANCE;
    }

    @Override
    public EPBSArchitecturePkg createEPBSArchitecturePkg(String name_p) {
        EPBSArchitecturePkg epbsArchitecturePkg = this.createEPBSArchitecturePkg();
        epbsArchitecturePkg.setName(name_p);
        return epbsArchitecturePkg;
    }

    @Override
    public EPBSArchitecture createEPBSArchitecture(String name_p) {
        EPBSArchitecture epbsArchitecture = this.createEPBSArchitecture();
        epbsArchitecture.setName(name_p);
        return epbsArchitecture;
    }

    @Override
    public EPBSContext createEPBSContext(String name_p) {
        EPBSContext epbsContext = this.createEPBSContext();
        epbsContext.setName(name_p);
        return epbsContext;
    }

    @Override
    public ConfigurationItemPkg createConfigurationItemPkg(String name_p) {
        ConfigurationItemPkg configurationItemPkg = this.createConfigurationItemPkg();
        configurationItemPkg.setName(name_p);
        return configurationItemPkg;
    }

    @Override
    public ConfigurationItem createConfigurationItem(String name_p) {
        ConfigurationItem configurationItem = this.createConfigurationItem();
        configurationItem.setName(name_p);
        return configurationItem;
    }
}

