/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NumericTypeKind implements Enumerator
{
    INTEGER(0, "INTEGER", "INTEGER"),
    FLOAT(1, "FLOAT", "FLOAT");

    public static final int INTEGER_VALUE = 0;
    public static final int FLOAT_VALUE = 1;
    private static final NumericTypeKind[] VALUES_ARRAY;
    public static final List<NumericTypeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NumericTypeKind[]{INTEGER, FLOAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NumericTypeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NumericTypeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NumericTypeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NumericTypeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NumericTypeKind get(int value) {
        switch (value) {
            case 0: {
                return INTEGER;
            }
            case 1: {
                return FLOAT;
            }
        }
        return null;
    }

    private NumericTypeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

