/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InteractionOperatorKind implements Enumerator
{
    UNSET(11, "UNSET", "UNSET"),
    ALT(0, "ALT", "ALT"),
    OPT(1, "OPT", "OPT"),
    PAR(2, "PAR", "PAR"),
    LOOP(3, "LOOP", "LOOP"),
    CRITICAL(4, "CRITICAL", "CRITICAL"),
    NEG(5, "NEG", "NEG"),
    ASSERT(6, "ASSERT", "ASSERT"),
    STRICT(7, "STRICT", "STRICT"),
    SEQ(8, "SEQ", "SEQ"),
    IGNORE(9, "IGNORE", "IGNORE"),
    CONSIDER(10, "CONSIDER", "CONSIDER");

    public static final int UNSET_VALUE = 11;
    public static final int ALT_VALUE = 0;
    public static final int OPT_VALUE = 1;
    public static final int PAR_VALUE = 2;
    public static final int LOOP_VALUE = 3;
    public static final int CRITICAL_VALUE = 4;
    public static final int NEG_VALUE = 5;
    public static final int ASSERT_VALUE = 6;
    public static final int STRICT_VALUE = 7;
    public static final int SEQ_VALUE = 8;
    public static final int IGNORE_VALUE = 9;
    public static final int CONSIDER_VALUE = 10;
    private static final InteractionOperatorKind[] VALUES_ARRAY;
    public static final List<InteractionOperatorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InteractionOperatorKind[]{UNSET, ALT, OPT, PAR, LOOP, CRITICAL, NEG, ASSERT, STRICT, SEQ, IGNORE, CONSIDER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InteractionOperatorKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionOperatorKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionOperatorKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionOperatorKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionOperatorKind get(int value) {
        switch (value) {
            case 11: {
                return UNSET;
            }
            case 0: {
                return ALT;
            }
            case 1: {
                return OPT;
            }
            case 2: {
                return PAR;
            }
            case 3: {
                return LOOP;
            }
            case 4: {
                return CRITICAL;
            }
            case 5: {
                return NEG;
            }
            case 6: {
                return ASSERT;
            }
            case 7: {
                return STRICT;
            }
            case 8: {
                return SEQ;
            }
            case 9: {
                return IGNORE;
            }
            case 10: {
                return CONSIDER;
            }
        }
        return null;
    }

    private InteractionOperatorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

