/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl;

import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resource.AbstractCoreResourceProvider;

public class GenmodelProviderImpl
extends AbstractCoreResourceProvider {
    public GenModel getGenModel() throws ViewpointResourceException {
        GenModel genModel = null;
        EObject rootElement = this.getRootElement();
        if (rootElement != null) {
            genModel = (GenModel)rootElement;
        }
        return genModel;
    }

    public GenPackage getGenPackage() throws ViewpointResourceException {
        GenPackage genPackage = null;
        GenModel genModel = this.getGenModel();
        if (genModel != null) {
            genPackage = (GenPackage)genModel.getGenPackages().get(0);
        }
        return genPackage;
    }

    public String getModelPluginName() throws ViewpointResourceException {
        return this.getProjectID(PluginKind.Model);
    }

    public String getEditPluginName() throws ViewpointResourceException {
        return this.getProjectID(PluginKind.Edit);
    }

    public String getEditorPluginName() throws ViewpointResourceException {
        return this.getProjectID(PluginKind.Editor);
    }

    public String getTestPluginName() throws ViewpointResourceException {
        return this.getProjectID(PluginKind.Tests);
    }

    private String getProjectID(PluginKind kind) throws ViewpointResourceException {
        GenModel genModel = this.getGenModel();
        if (genModel != null) {
            switch (kind) {
                case Model: {
                    return genModel.getModelPluginID();
                }
                case Edit: {
                    return genModel.getEditPluginID();
                }
                case Editor: {
                    return genModel.getEditorPluginID();
                }
                case Tests: {
                    return genModel.getTestsPluginID();
                }
            }
        }
        throw new ViewpointResourceException(this.getResourceFileInformations(), 10);
    }

    @Override
    protected void loadResourceFromFile() {
        super.loadResourceFromFile();
        this.reloadGenModel();
    }

    @Override
    public void refresh() {
        this.reloadGenModel();
        super.refresh();
    }

    private void reloadGenModel() {
        try {
            GenModel genModel = this.getGenModel();
            genModel.reconcile();
            genModel.setCanGenerate(true);
            genModel.setValidateModel(true);
            genModel.diagnose();
            genModel.validate();
        }
        catch (ViewpointResourceException e) {
            e.printStackTrace();
        }
    }

    private static enum PluginKind {
        Model,
        Edit,
        Editor,
        Tests;

    }
}

