/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.mdsofa.common.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.IUserEnforcedHelper;
import org.polarsys.capella.common.mdsofa.common.helper.ProjectHelper;

public class FileHelper {
    private static final Logger __logger = Logger.getLogger((String)FileHelper.class.getPackage().getName());

    public static URL getFileFullUrl(String fileRelativePath_p) {
        return FileHelper.getFileFullUrl(FileHelper.getFileFullUri(fileRelativePath_p));
    }

    public static URL getFileFullUrl(URI fileFullUri_p) {
        URL result = null;
        try {
            result = FileLocator.resolve((URL)new URL(fileFullUri_p.toString()));
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.getFileFullPath(..) _ ");
            loggerMessage.append("Unable to resolve the url for ").append(fileFullUri_p.toString());
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    public static URI getFileFullUri(String fileRelativePath_p) {
        URI fileUri = null;
        if (fileRelativePath_p == null) {
            return fileUri;
        }
        Path path = new Path(fileRelativePath_p);
        IProject project = ProjectHelper.getProject(path.segment(0));
        fileUri = project != null && project.exists() ? URI.createPlatformResourceURI((String)fileRelativePath_p, (boolean)true) : URI.createPlatformPluginURI((String)fileRelativePath_p, (boolean)true);
        return fileUri;
    }

    public static String convertPackageNameToFolderPath(String packageName_p) {
        String result = null;
        if (packageName_p != null) {
            result = packageName_p.replace('.', '/');
        }
        return result;
    }

    public static byte[] readFile(InputStream inputStream_p) {
        byte[] buffer;
        block15: {
            buffer = null;
            try {
                try {
                    int readBytes;
                    int sizeToRead = inputStream_p.available();
                    buffer = new byte[sizeToRead];
                    int totalReadBytes = readBytes = inputStream_p.read(buffer);
                    while (readBytes != -1 && totalReadBytes < sizeToRead) {
                        readBytes = inputStream_p.read(buffer, totalReadBytes, sizeToRead - totalReadBytes);
                        if (readBytes == -1) continue;
                        totalReadBytes += readBytes;
                    }
                }
                catch (Exception exception_p) {
                    StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                    loggerMessage.append("Failed to read the input stream ! ");
                    __logger.warn((Object)loggerMessage.toString());
                    if (inputStream_p != null) {
                        try {
                            inputStream_p.close();
                        }
                        catch (IOException exception_p2) {
                            StringBuilder loggerMessage2 = new StringBuilder("FileHelper.readFile(..) _ ");
                            loggerMessage2.append("Failed to close input stream ! ");
                            __logger.warn((Object)loggerMessage2.toString(), (Throwable)exception_p2);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream_p != null) {
                    try {
                        inputStream_p.close();
                    }
                    catch (IOException exception_p) {
                        StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                        loggerMessage.append("Failed to close input stream ! ");
                        __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    }
                }
                throw throwable;
            }
            if (inputStream_p != null) {
                try {
                    inputStream_p.close();
                }
                catch (IOException exception_p) {
                    StringBuilder loggerMessage = new StringBuilder("FileHelper.readFile(..) _ ");
                    loggerMessage.append("Failed to close input stream ! ");
                    __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                }
            }
        }
        return buffer == null ? new byte[]{} : buffer;
    }

    public static String readFile(String filePath_p) throws UnsupportedEncodingException {
        byte[] rawContent = FileHelper.readRawFile(filePath_p);
        String result = rawContent.length == 0 ? "" : new String(rawContent, "UTF-8");
        return result;
    }

    public static InputStream getFileAsStream(String filePath_p) {
        InputStream result = null;
        URL fileURL = FileHelper.getFileFullUrl(filePath_p);
        try {
            result = fileURL.openStream();
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.getFileAsStream(..) _ ");
            loggerMessage.append("Failed to load ").append(filePath_p);
            __logger.warn((Object)loggerMessage.toString());
        }
        return result;
    }

    public static byte[] readRawFile(String filePath_p) {
        byte[] result = null;
        InputStream inputStream = FileHelper.getFileAsStream(filePath_p);
        if (inputStream != null) {
            result = FileHelper.readFile(inputStream);
        }
        return result == null ? new byte[]{} : result;
    }

    public static void copyFile(String sourceFileRelativePath_p, String targetFileRelativePath_p) {
        byte[] content = FileHelper.readRawFile(sourceFileRelativePath_p);
        FileHelper.writeFile(targetFileRelativePath_p, true, content);
    }

    public static boolean writeFile(String filePath_p, boolean ensureFolders_p, String contents_p) {
        return FileHelper.writeFile(filePath_p, ensureFolders_p, contents_p.getBytes(Charset.forName("UTF-8")));
    }

    public static boolean writeFile(String filePath_p, boolean ensureFolders_p, byte[] contents_p) {
        boolean result;
        block14: {
            result = false;
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    boolean fileWritable;
                    String fileFullPath = FileHelper.getFileFullUrl(FileHelper.getFileFullUri(filePath_p)).getFile();
                    if (ensureFolders_p) {
                        FileHelper.ensurePathAvailability(fileFullPath);
                    }
                    if (fileWritable = FileHelper.makeFileWritable(filePath_p)) {
                        channel = new FileOutputStream(fileFullPath).getChannel();
                        ((FileChannel)channel).write(ByteBuffer.wrap(contents_p));
                        result = true;
                    }
                }
                catch (Exception exception_p) {
                    result = false;
                    StringBuilder loggerMessage = new StringBuilder("FileHelper.writeFile(..) _ ");
                    loggerMessage.append("Failed to open channel in write mode for ");
                    loggerMessage.append(filePath_p).append(" !");
                    __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    if (channel == null || !channel.isOpen()) break block14;
                    try {
                        channel.close();
                    }
                    catch (IOException exception_p2) {
                        result = false;
                        StringBuilder loggerMessage2 = new StringBuilder("FileHelper.writeFile(..) _ ");
                        loggerMessage2.append("Failed to close opened channel in write mode ! ");
                        loggerMessage2.append(filePath_p).append(" may no longer be usable.");
                        __logger.warn((Object)loggerMessage2.toString(), (Throwable)exception_p2);
                    }
                }
            }
            finally {
                if (channel != null && channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (IOException exception_p) {
                        result = false;
                        StringBuilder loggerMessage = new StringBuilder("FileHelper.writeFile(..) _ ");
                        loggerMessage.append("Failed to close opened channel in write mode ! ");
                        loggerMessage.append(filePath_p).append(" may no longer be usable.");
                        __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
                    }
                }
            }
        }
        return result;
    }

    public static boolean renameFile(String sourceFileRelativePath_p, String destinationFileRelativePath_p) {
        if (sourceFileRelativePath_p == null || destinationFileRelativePath_p == null) {
            return false;
        }
        IFile sourceFile = FileHelper.getPlatformFile(sourceFileRelativePath_p);
        IPath destinationPath = FileHelper.getPlatformFile(destinationFileRelativePath_p).getFullPath();
        return FileHelper.moveResource((IResource)sourceFile, destinationPath);
    }

    public static boolean renameFolder(String sourceFolderRelativePath_p, String destinationFolderRelativePath_p) {
        if (sourceFolderRelativePath_p == null || destinationFolderRelativePath_p == null) {
            return false;
        }
        IFolder sourceFolder = FileHelper.getPlatformFolder(sourceFolderRelativePath_p);
        IPath destinationPath = FileHelper.getPlatformFolder(destinationFolderRelativePath_p).getFullPath();
        return FileHelper.moveResource((IResource)sourceFolder, destinationPath);
    }

    public static boolean moveResource(IResource resource_p, IPath destinationPath_p) {
        boolean result = false;
        try {
            resource_p.move(destinationPath_p, true, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        catch (Exception e_p) {
            StringBuilder loggerMessage = new StringBuilder("FileHelper.moveResource(..) _ ");
            loggerMessage.append("Could not move ").append(resource_p.getFullPath());
            loggerMessage.append(" to ").append(destinationPath_p);
            __logger.warn((Object)loggerMessage.toString(), (Throwable)e_p);
        }
        return result;
    }

    public static boolean exists(String fileRelativePath_p) {
        IFile file = FileHelper.getPlatformFile(fileRelativePath_p);
        return file != null ? file.exists() : false;
    }

    public static void ensurePathAvailability(String fileFullPath_p) {
        IPath parentFolderPath = new Path(fileFullPath_p).removeFileExtension().removeLastSegments(1);
        if (!parentFolderPath.isEmpty()) {
            File parentFolder = parentFolderPath.toFile();
            parentFolder.mkdirs();
        }
    }

    public static boolean deleteFile(String workspaceRelativeFile_p) {
        boolean result = false;
        IFile fileToDelete = FileHelper.getPlatformFile(workspaceRelativeFile_p);
        if (fileToDelete != null && fileToDelete.exists()) {
            try {
                fileToDelete.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = true;
            }
            catch (CoreException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("FileHelper.deleteFile(..) _ ");
                loggerMessage.append("Failed to delete file:").append(workspaceRelativeFile_p);
                __logger.warn((Object)loggerMessage.toString());
            }
        }
        return result;
    }

    public static boolean deleteFolder(String workspaceRelativePath_p) {
        boolean result = false;
        IFolder folderToDelete = FileHelper.getPlatformFolder(workspaceRelativePath_p);
        if (folderToDelete != null && folderToDelete.exists()) {
            try {
                folderToDelete.delete(true, (IProgressMonitor)new NullProgressMonitor());
                result = true;
            }
            catch (CoreException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("FileHelper.deleteFolder(..) _ ");
                loggerMessage.append("Failed to delete folder:").append(workspaceRelativePath_p);
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return result;
    }

    public static IFile getPlatformFile(String fileRelativePath_p) {
        IFile result = null;
        if (fileRelativePath_p == null) {
            return result;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        result = root.getFile((IPath)new Path(fileRelativePath_p));
        return result;
    }

    public static IFolder getPlatformFolder(String folderRelativePath_p) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFolder((IPath)new Path(folderRelativePath_p));
    }

    public static String getFileExtension(String filePath_p) {
        return new Path(filePath_p).getFileExtension();
    }

    public static boolean makeFileWritable(String filePath_p) {
        IUserEnforcedHelper helper = SolFaCommonActivator.getDefault().getUserEnforcedHelper();
        IStatus status = helper.makeFileWritable(FileHelper.getPlatformFile(filePath_p));
        return status.isOK();
    }
}

