/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.label.InitInterpreterFromParsedVariableTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class DirectEditCommandBuilder
extends AbstractDiagramCommandBuilder {
    private DRepresentationElement repElement;
    private DirectEditLabel directEditTool;
    private String newValue;

    public DirectEditCommandBuilder(DRepresentationElement repElement, DirectEditLabel directEditTool, String newValue) {
        this.repElement = repElement;
        this.directEditTool = directEditTool;
        this.newValue = newValue;
    }

    public Command buildCommand() {
        if (this.permissionAuthority.canEditInstance((EObject)this.repElement) && this.canDirectEdit()) {
            DCommand result = this.createEnclosingCommand();
            String messageFormat = "$0";
            if (this.directEditTool.getMask() != null) {
                messageFormat = this.directEditTool.getMask().getMask();
            }
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.repElement);
            result.getTasks().add(new InitInterpreterFromParsedVariableTask(interpreter, messageFormat, this.newValue));
            Option<DDiagram> parentDiagram = this.getDDiagram();
            if (parentDiagram.some() && this.repElement.getTarget() != null && this.directEditTool.getInitialOperation() != null) {
                ICommandTask operations = this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), this.repElement.getTarget(), this.directEditTool.getInitialOperation().getFirstModelOperations());
                result.getTasks().add(operations);
            }
            this.addPostOperationTasks(result, interpreter);
            return result;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public boolean canDirectEdit() {
        boolean valid = !this.isInLayoutingModeDiagram((EObject)this.repElement);
        valid = valid && this.checkPrecondition((DDiagramElement)this.repElement, (AbstractToolDescription)this.directEditTool);
        return valid;
    }

    protected void addPostOperationTasks(DCommand command, IInterpreter interpreter) {
        if (this.repElement instanceof DDiagramElement) {
            this.addRefreshTask((DDiagramElement)this.repElement, command, (AbstractToolDescription)this.directEditTool);
            Option<DDiagram> parentDiagram = new EObjectQuery((EObject)this.repElement).getParentDiagram();
            command.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.directEditTool, interpreter, this.repElement.getTarget(), (DRepresentation)parentDiagram.get()));
        }
    }

    protected String getEnclosingCommandLabel() {
        return Messages.DirectEditCommandBuilder_editLabel;
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return new EObjectQuery((EObject)this.repElement).getParentDiagram();
    }
}

