/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.widget.editor.MDERichTextEditorInput;
import org.polarsys.kitalpha.richtext.widget.editor.intf.MDERichTextEditorCallback;
import org.polarsys.kitalpha.richtext.widget.factory.MDERichTextFactory;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.internal.extension.MDERichTextExtensionManager;

public class MDERichTextEditor
extends EditorPart
implements ITabbedPropertySheetPageContributor {
    private static final String SAVE_CALLBACK_EXTENSION_ID = "org.polarsys.kitalpha.richtext.widget.saveResourceCallback";
    private static final String SAVE_CALLBACK_CLASS_ATTR = "class";
    private MDERichTextWidget widget;
    private final MDERichTextExtensionManager propertySheetExtensionManager = new MDERichTextExtensionManager(this);
    private TabbedPropertySheetPage propertySheetPage;
    private final IWorkbenchListener closeListener = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.closeEditor((IEditorPart)MDERichTextEditor.this, true);
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };

    public MDERichTextEditor() {
        PlatformUI.getWorkbench().addWorkbenchListener(this.closeListener);
    }

    public void doSave(IProgressMonitor monitor) {
        this.widget.saveContent();
        this.doSaveCallback(this.widget);
        this.firePropertyChange(257);
        this.firePropertyChange(1);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setMDERichTextEditorPartName();
        this.getEditorSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener_p) {
            }

            public ISelection getSelection() {
                EObject modelElement = MDERichTextEditor.this.widget.getElement();
                return modelElement != null ? new StructuredSelection((Object)modelElement) : StructuredSelection.EMPTY;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener_p) {
            }

            public void setSelection(ISelection selection_p) {
            }
        });
    }

    private void setMDERichTextEditorPartName() {
        String title = this.getEditorInput().getName();
        this.setPartName(title);
    }

    public boolean isDirty() {
        boolean resourceState = this.doCheckWorkspaceResourceStatus(this.widget);
        if (resourceState) {
            return this.widget.isDirty();
        }
        return this.widget.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.widget = new MDERichTextFactory().createEditorRichTextWidget(parent);
        MDERichTextEditorInput input = (MDERichTextEditorInput)this.getEditorInput();
        this.widget.setSaveStrategy(input.getSaveStrategy());
        this.widget.bind(input.getElement(), input.getFeature());
        new BrowserFunction(((MDENebulaBasedRichTextWidget)this.widget).getBrowser(), "firePropertyChangeEvent"){

            public Object function(Object[] arguments) {
                MDERichTextEditor.this.firePropertyChange(257);
                return null;
            }
        };
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void dispose() {
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
            this.propertySheetPage = null;
        }
        super.dispose();
        this.widget.dispose();
        PlatformUI.getWorkbench().removeWorkbenchListener(this.closeListener);
    }

    public String getContributorId() {
        return this.propertySheetExtensionManager.getContributorId();
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = this.propertySheetExtensionManager.getDelegate();
        }
        return this.propertySheetPage;
    }

    public Object getAdapter(Class adapter_p) {
        if (IPropertySheetPage.class.equals((Object)adapter_p)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter_p);
    }

    private void doSaveCallback(MDERichTextWidget widget) {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(SAVE_CALLBACK_EXTENSION_ID);
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension(SAVE_CALLBACK_CLASS_ATTR);
                    callback.saveWorkspaceResource(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
    }

    private boolean doCheckWorkspaceResourceStatus(MDERichTextWidget widget) {
        boolean result = true;
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(SAVE_CALLBACK_EXTENSION_ID);
        if (contributions != null && contributions.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                try {
                    MDERichTextEditorCallback callback = (MDERichTextEditorCallback)c.createExecutableExtension(SAVE_CALLBACK_CLASS_ATTR);
                    result &= callback.isWorkspaceResourceDirty(widget);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                ++n2;
            }
        }
        return result;
    }
}

