/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.factory;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaRichTextConfiguration;
import org.polarsys.kitalpha.richtext.nebula.widget.toolbar.MDERichTextToolbarItemHandler;
import org.polarsys.kitalpha.richtext.widget.MDERichtextWidgetEditorImpl;
import org.polarsys.kitalpha.richtext.widget.MDERichtextWidgetImpl;
import org.polarsys.kitalpha.richtext.widget.editor.tools.OpenInEditorHandler;
import org.polarsys.kitalpha.richtext.widget.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.AddImageHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.AddLinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.handlers.ClearContentHandler;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Constants;

public class MDERichTextFactory {
    private final MDENebulaRichTextConfiguration configuration = new MDENebulaRichTextConfiguration();

    public MDERichTextFactory() {
        this.initializeDefaultConfiguration();
    }

    public MDERichTextFactory(String basePath) {
        this();
        this.setBaseHrefPath(basePath);
    }

    protected void initializeDefaultConfiguration() {
        this.configuration.setOption("readOnly", (Object)false);
        this.configuration.setOption("pasteFromWordPromptCleanup", (Object)false);
    }

    public MDERichTextWidget createEditorRichTextWidget(Composite parent) {
        this.initializeMDEDefaultToolbar(false);
        MDERichtextWidgetEditorImpl widget = new MDERichtextWidgetEditorImpl(parent, this.configuration);
        this.addEditorToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createEditorRichTextWidget(Composite parent, int style) {
        this.initializeMDEDefaultToolbar(false);
        MDERichtextWidgetEditorImpl widget = new MDERichtextWidgetEditorImpl(parent, this.configuration, style);
        this.addEditorToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createDefaultRichTextWidget(Composite parent) {
        this.initializeMDEDefaultToolbar(true);
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createDefaultRichTextWidget(Composite parent, int style) {
        this.initializeMDEDefaultToolbar(true);
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration, style);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createMinimalRichTextWidget(Composite parent) {
        this.initializeMDEMinimalToolbar();
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    public MDERichTextWidget createMinimalRichTextWidget(Composite parent, int style) {
        this.initializeMDEMinimalToolbar();
        this.removeUselessItemFromToolbar();
        MDERichtextWidgetImpl widget = new MDERichtextWidgetImpl(parent, this.configuration, style);
        this.addToolbarItems((MDENebulaBasedRichTextWidget)widget);
        this.initEditorItemStates((MDERichTextWidget)widget);
        return widget;
    }

    private void removeUselessItemFromToolbar() {
        this.configuration.removeToolbarItems(new String[]{"Link", "Anchor", "Strike", "PasteFromWord", "PasteText"});
    }

    protected void addEditorToolbarItems(MDENebulaBasedRichTextWidget widget) {
        widget.addToolbarItem((MDERichTextWidget)widget, "Clean", "Clean", "Clean", "clean", Constants.CLEAR_ICON, (MDERichTextToolbarItemHandler)new ClearContentHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "Addlink", "Addlink", "Link", "mdelinks", Constants.ADD_LINK_ICON, (MDERichTextToolbarItemHandler)new AddLinkHandler());
        widget.addToolbarItem((MDERichTextWidget)widget, "AddImage", "AddImage", "Add Image", "mdelinks", Constants.ADD_IMAGE_ICON, (MDERichTextToolbarItemHandler)new AddImageHandler());
    }

    protected void addToolbarItems(MDENebulaBasedRichTextWidget widget) {
        try {
            widget.addToolbarItem((MDERichTextWidget)widget, "openEditor", "openEditor", "Open in Editor", "enableEdit", FileLocator.toFileURL((URL)MDERichTextHelper.getURL((String)"org.polarsys.kitalpha.richtext.widget", (String)"icons/openInEditor.gif")), (MDERichTextToolbarItemHandler)new OpenInEditorHandler());
        }
        catch (IOException e) {
            Status status = new Status(2, "org.polarsys.kitalpha.richtext.widget", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.addEditorToolbarItems(widget);
    }

    protected MDERichTextFactory initializeMDEDefaultToolbar(boolean addOpenInEditor) {
        if (addOpenInEditor) {
            this.configuration.initializeToolbarItem("enableEdit", new String[]{"openEditor"});
        }
        this.configuration.initializeToolbarItem("styles", new String[0]);
        this.configuration.initializeToolbarItem("clipboard", new String[0]);
        this.configuration.initializeToolbarItem("clean", new String[]{"Clean"});
        this.configuration.initializeToolbarItem("basicstyles", new String[]{"Bold", "Italic", "Underline", "Subscript", "Superscript"});
        this.configuration.initializeToolbarItem("colors", new String[0]);
        this.configuration.initializeToolbarItem("paragraph", new String[]{"list", "indent"});
        this.configuration.initializeToolbarItem("editing", new String[]{"Find"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"Addlink"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"AddImage"});
        this.removeUselessItemFromToolbar();
        return this;
    }

    protected MDERichTextFactory initializeMDEMinimalToolbar() {
        this.configuration.initializeToolbarItem("enableEdit", new String[]{"openEditor"});
        this.configuration.initializeToolbarItem("styles", new String[0]);
        this.configuration.initializeToolbarItem("basicstyles", new String[]{"list"});
        this.configuration.initializeToolbarItem("mdelinks", new String[]{"Addlink"});
        return this;
    }

    private void initEditorItemStates(MDERichTextWidget editor) {
        editor.setToolbarItemState("Editable", "CKEDITOR.TRISTATE_ON");
    }

    public MDERichTextFactory initializeToolbarItem(String toolbar, String ... items) {
        this.configuration.initializeToolbarItem(toolbar, items);
        return this;
    }

    public MDERichTextFactory setToolbarColor(String hexaCode) {
        Assert.isNotNull((Object)hexaCode);
        this.configuration.setOption("uiColor", (Object)hexaCode);
        return this;
    }

    public MDERichTextFactory setConfigurationFile(String path) {
        this.configuration.setOption("customConfig", (Object)path);
        return this;
    }

    public MDERichTextFactory setToolbarPosition(String position) {
        this.configuration.setToolbarPosition(position);
        return this;
    }

    public MDERichTextFactory setBaseHrefPath(String basePath) {
        this.configuration.setOption("baseHref", (Object)basePath);
        return this;
    }

    public RichTextEditorConfiguration getConfiguration() {
        return this.configuration;
    }
}

