/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers.ParentHelper;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class LoadViewpointModelDialog
extends TitleAreaDialog {
    private ListViewer viewer;
    private List<Resource> result = new ArrayList<Resource>();
    private Viewpoint viewpoint;

    public LoadViewpointModelDialog(Shell shell, Viewpoint viewpoint) {
        super(shell);
        this.viewpoint = viewpoint;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.createWidgets(contents);
        this.init();
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    public void init() {
        this.viewer.setInput((Object)ParentHelper.getCandidateResources((EObject)this.viewpoint));
    }

    private void createWidgets(Composite parent) {
        this.viewer = new ListViewer(parent);
        this.viewer.getList().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LoadViewpointModelDialog.this.getButton(0).setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LoadViewpointModelDialog.this.okPressed();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Resource vp = (Resource)element;
                if (vp.getName() == null) {
                    return "No name  [" + vp.getProviderSymbolicName() + "]";
                }
                return String.valueOf(vp.getName()) + "  [" + vp.getProviderSymbolicName() + "]";
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.Dialog_Add_label, true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.LoadAFModelDialog_title);
        this.setMessage(Messages.LoadAFModelDialog_description);
        return contents;
    }

    protected void okPressed() {
        IStructuredSelection ss = (IStructuredSelection)this.viewer.getSelection();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.result.add((Resource)obj);
            ++n2;
        }
        super.okPressed();
    }

    public List<Resource> getResult() {
        return this.result;
    }
}

