/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.integration.services;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.dialogs.NewElementCreationWizard;
import org.polarsys.kitalpha.ad.viewpoint.ui.integration.services.NewServiceWizardPage;
import org.polarsys.kitalpha.ad.viewpoint.utils.ElementHelper;

public class NewServiceCreationWizard
extends NewElementCreationWizard {
    protected final IServiceHandler handler;

    public NewServiceCreationWizard(IServiceHandler handler) {
        this.handler = handler;
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setWindowTitle(Messages.NewServiceCreationWizard_title);
        this.requiredDependencies.add("org.polarsys.kitalpha.ad.viewpoint");
        this.fPage = new NewServiceWizardPage();
    }

    @Override
    protected void postFinishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        super.postFinishPage(monitor);
        String id = ElementHelper.computeNewId((IElementHandler)this.handler, (String)this.getElementName().toLowerCase().replaceAll("\\s", "\\."));
        this.handler.createService(id, "New Service", this.getServiceType(), new ArrayList());
    }

    @Override
    protected void manageManifestFile(IPluginModelBase model) throws CoreException {
        IPluginModelFactory factory = model.getPluginFactory();
        IPluginBase base = model.getPluginBase();
        IPluginExtension extension = factory.createExtension();
        extension.setPoint("org.polarsys.kitalpha.ad.viewpoint.implementation.services");
        model.getExtensions().add(extension);
        IPluginElement element = factory.createElement((IPluginObject)extension);
        element.setName("Implementation");
        element.setAttribute("label", this.getElementName());
        element.setAttribute("type", this.getServiceType());
        element.setAttribute("class", this.getFullClassname());
        extension.add((IPluginObject)element);
    }

    @Override
    protected IDialogSettings getDialogSettingSection() {
        return this.getDialogSettings().getSection("service.provider.wizard.section");
    }

    protected String getServiceType() {
        return ((NewServiceWizardPage)this.fPage).getServiceType();
    }
}

