/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.dialog;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;

public class ProgressMonitoringLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IColorProvider {
    private int _foregroundColor;
    private TreeViewer _viewer;

    public ProgressMonitoringLabelProvider(TreeViewer viewer, int foregroundColorForReferencingElements) {
        super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
        this._foregroundColor = foregroundColorForReferencingElements;
        this._viewer = viewer;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object input = this._viewer.getInput();
        if (input instanceof TreeData && ((TreeData)input).isValid(element)) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            return display.getSystemColor(this._foregroundColor);
        }
        return null;
    }

    public String getText(Object object) {
        String text = super.getText(object);
        return text.replace("%20", " ");
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        if (columnIndex == 0) {
            text = this.getText(element);
        } else if (1 == columnIndex) {
            DRepresentationDescriptor representationDesc;
            String eAnnot;
            DAnnotation dAnnotation;
            EnumerationPropertyLiteral status;
            if (element instanceof CapellaElement && (status = ((CapellaElement)element).getStatus()) != null) {
                text = status.getLabel();
            }
            if (element instanceof DRepresentationDescriptor && (dAnnotation = RepresentationHelper.getAnnotation((String)(eAnnot = "http://www.polarsys.org/capella/core/ProgressStatus"), (DRepresentation)(representationDesc = (DRepresentationDescriptor)element).getRepresentation())) != null) {
                text = (String)dAnnotation.getDetails().get((Object)"value");
            }
        } else if (2 == columnIndex) {
            DRepresentationDescriptor representationDesc;
            String eAnnot;
            DAnnotation dAnnotation;
            String review;
            if (element instanceof CapellaElement && (review = ((CapellaElement)element).getReview()) != null) {
                text = review;
            }
            if (element instanceof DRepresentationDescriptor && (dAnnotation = RepresentationHelper.getAnnotation((String)(eAnnot = "http://www.polarsys.org/capella/core/StatusReview"), (DRepresentation)(representationDesc = (DRepresentationDescriptor)element).getRepresentation())) != null) {
                text = (String)dAnnotation.getDetails().get((Object)"value");
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.getImage(element);
        }
        return image;
    }
}

