/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.ui.services.helper.EObjectImageProviderHelper;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;

public class Utils {
    public static EObject getLayer(SystemEngineering se, EClass eClassLayer) {
        if (se == null) {
            return null;
        }
        EObject result = null;
        for (EObject current : se.getOwnedArchitectures()) {
            if (current.eClass() != eClassLayer) continue;
            result = current;
            break;
        }
        return result;
    }

    public static List<EClass> getLayers() {
        ArrayList<EClass> result = new ArrayList<EClass>();
        result.add(OaPackage.Literals.OPERATIONAL_ANALYSIS);
        result.add(CtxPackage.Literals.SYSTEM_ANALYSIS);
        result.add(LaPackage.Literals.LOGICAL_ARCHITECTURE);
        result.add(PaPackage.Literals.PHYSICAL_ARCHITECTURE);
        result.add(EpbsPackage.Literals.EPBS_ARCHITECTURE);
        return result;
    }

    public static Image getImage(EObject eObject) {
        Image result = null;
        IItemLabelProvider itemProvider = Utils.getIItemLabelProvider(eObject);
        if (itemProvider != null) {
            result = EObjectImageProviderHelper.getImageFromObject((Object)itemProvider.getImage((Object)eObject));
        }
        return result;
    }

    public static String getText(EObject eObject) {
        String result = "";
        IItemLabelProvider itemProvider = Utils.getIItemLabelProvider(eObject);
        if (itemProvider != null) {
            result = itemProvider.getText((Object)eObject);
        }
        return result;
    }

    private static IItemLabelProvider getIItemLabelProvider(EObject object) {
        return (IItemLabelProvider)CapellaAdapterFactoryProvider.getInstance().getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
    }

    public static EObject getTarget(DRepresentation representation) {
        if (representation instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)representation).getTarget();
        }
        if (representation instanceof DTable) {
            return ((DTable)representation).getTarget();
        }
        return null;
    }
}

