/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.environment.AbstractGenericTypeUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.ImageSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternWizard<T extends ITemplatePatternBasedSpecification>
extends Wizard {
    private final T _data;
    private boolean _isSuccessful;
    private boolean _isDisposed;
    private final List<Object> _graphicalContext;
    private Image _image;
    protected TemplatePattern _patternForImage;
    private final boolean _generatePatternImage;
    private final Collection<IPatternImageChangedListener> _listeners;
    private boolean _modifiedRepositoryRegistry;
    protected AbstractGenericTypeUtil _genericTypeUtil = CorePatternsPlugin.getDefault().getGenericTypeUtil();
    protected AbstractDiagramUtil _diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();

    public AbstractPatternWizard(T data_p) {
        this(data_p, Collections.emptyList(), true);
        this._modifiedRepositoryRegistry = false;
    }

    public AbstractPatternWizard(T data_p, List<Object> graphicalContext_p, boolean generatePatternImage_p) {
        this._data = data_p;
        this._isSuccessful = false;
        this._isDisposed = false;
        this._graphicalContext = Collections.unmodifiableList(graphicalContext_p);
        this._image = null;
        this._patternForImage = null;
        this._generatePatternImage = generatePatternImage_p;
        this._listeners = new HashSet<IPatternImageChangedListener>();
    }

    public final void addPages() {
        super.addPages();
        this.doAddPages();
        if (this._generatePatternImage && this.getData() instanceof ITemplatePatternSelection) {
            TemplatePattern currentPattern;
            final boolean modifiablePattern = this.getData() instanceof IModifiableTemplatePatternSpecification;
            if (this.getData().getPattern() != null && (currentPattern = this.getData().getPattern()).getImage() != null && this.getPatternImage() == null) {
                this.computePatternImageFromSpecification(currentPattern.getImage().getContents(), modifiablePattern);
            }
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    if (AbstractPatternWizard.this._patternForImage != newPattern_p) {
                        String imageSpecification = null;
                        if (newPattern_p != null && newPattern_p.getImage() != null) {
                            imageSpecification = newPattern_p.getImage().getContents();
                        }
                        AbstractPatternWizard.this.computePatternImageFromSpecification(imageSpecification, modifiablePattern);
                    }
                }
            });
        }
    }

    public void addSelectedPatternListener(IPatternImageChangedListener listener_p) {
        this._listeners.add(listener_p);
    }

    protected abstract void doAddPages();

    public boolean canFinish() {
        return this.getData().isComplete();
    }

    public void computePatternImageFromSpecification(String imageSpecification_p, boolean updatePattern_p) {
        Job job = this.instantiatePatternImageBuilderJob(this, imageSpecification_p, updatePattern_p);
        job.schedule();
    }

    public void computePatternImageFromGraphicalContext(boolean updatePattern_p) {
        Job job = this.instantiatePatternImageBuilderJob(this, this._graphicalContext, updatePattern_p);
        job.schedule();
    }

    public synchronized void dispose() {
        super.dispose();
        if (this._image != null) {
            this._image.dispose();
        }
        this._isDisposed = true;
    }

    protected abstract boolean doPerformFinish();

    protected <E> E execute(final IModelOperation<E> operation_p) {
        final LinkedList wrapper = new LinkedList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                wrapper.add(CorePatternsPlugin.getDefault().getModelEnvironment().execute(operation_p));
            }
        });
        return wrapper.get(0);
    }

    public T getData() {
        return this._data;
    }

    protected List<Object> getGraphicalContext() {
        return Collections.unmodifiableList(this._graphicalContext);
    }

    public synchronized Image getPatternImage() {
        return this._image;
    }

    public synchronized boolean isDisposed() {
        return this._isDisposed;
    }

    public boolean isSuccessful() {
        return this._isSuccessful;
    }

    public boolean mayHaveImage() {
        return !this._graphicalContext.isEmpty();
    }

    protected void notifyRepositoryRegistryChanged() {
        this._modifiedRepositoryRegistry = true;
    }

    protected void patternImageChanged() {
        Image changedImage = this.getPatternImage();
        for (IPatternImageChangedListener listener : this._listeners) {
            listener.patternImageChanged(changedImage);
        }
    }

    public final boolean performFinish() {
        final ArrayList resultWrapper = new ArrayList(1);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AbstractPatternWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            boolean result = AbstractPatternWizard.this.doPerformFinish();
                            resultWrapper.add(result);
                        }
                    });
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._isSuccessful = !resultWrapper.isEmpty() && (Boolean)resultWrapper.get(0) != false;
        return this._isSuccessful;
    }

    public boolean repositoryRegistryChanged() {
        return this._modifiedRepositoryRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPatternImage(final TemplatePattern pattern_p, final String imageSpecifiation_p, Image image_p, final boolean updatePattern_p) {
        if (this.isDisposed()) {
            if (image_p != null) {
                image_p.dispose();
            }
        } else {
            Image oldImage;
            AbstractPatternWizard abstractPatternWizard = this;
            synchronized (abstractPatternWizard) {
                oldImage = this._image;
                this._image = image_p;
                this._patternForImage = pattern_p;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractPatternWizard.this.getData().getPattern() == pattern_p) {
                        if (updatePattern_p) {
                            ImageSpecification image = null;
                            if (imageSpecifiation_p != null) {
                                image = TemplatepatternsFactory.eINSTANCE.createImageSpecification();
                                image.setContents(imageSpecifiation_p);
                            }
                            pattern_p.setImage(image);
                        }
                        AbstractPatternWizard.this.patternImageChanged();
                    }
                }
            });
            if (oldImage != null) {
                oldImage.dispose();
            }
        }
    }

    protected abstract Job instantiatePatternImageBuilderJob(AbstractPatternWizard<T> var1, List<Object> var2, boolean var3);

    protected abstract Job instantiatePatternImageBuilderJob(AbstractPatternWizard<T> var1, String var2, boolean var3);

    public static interface IPatternImageChangedListener {
        public void patternImageChanged(Image var1);
    }
}

