/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.editors;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.polarsys.capella.common.ui.toolkit.editors.IPageContentProvider;
import org.polarsys.capella.common.ui.toolkit.editors.ITabDescriptor;
import org.polarsys.capella.common.ui.toolkit.fields.MdeFieldEditor;
import org.polarsys.capella.common.ui.toolkit.viewers.FieldsViewer;

public abstract class Editor
extends Wizard {
    public EditorPage page;
    private IPreferenceStore store;

    public Editor(IPageContentProvider pageContentProvider, IPreferenceStore store) {
        this.page = new EditorPage(pageContentProvider);
        this.store = store;
    }

    public final void addPages() {
        this.addPage((IWizardPage)this.page);
        this.page.setPageComplete(true);
    }

    public void setEnabled(boolean enabled) {
        if (this.page != null) {
            this.page.setEnabled(enabled);
        }
    }

    public void setConsultMode(boolean consult) {
        if (this.page != null) {
            this.page.setConsultMode(consult);
        }
    }

    public void setPageTitle(String title) {
        if (this.page != null) {
            this.page.setTitle(title);
        }
    }

    public void setPageImage(ImageDescriptor image) {
        if (this.page != null) {
            this.page.setImageDescriptor(image);
        }
    }

    public String getPageTitle() {
        if (this.page != null) {
            return this.page.getTitle();
        }
        return null;
    }

    public void setPageDescription(String description) {
        if (this.page != null) {
            this.page.setDescription(description);
        }
    }

    public String getPageDescription() {
        if (this.page != null) {
            return this.page.getDescription();
        }
        return null;
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public EClass getElementType() {
        return this.page.getElementType();
    }

    protected class EditorPage
    extends WizardPage
    implements IPropertyChangeListener {
        private IPageContentProvider _contentProvider;
        private TabFolder _folder;
        private ArrayList<FieldsViewer> _containers;
        private boolean _consultMode;
        private boolean _isEnabled;
        private Color foreground;

        public EditorPage(IPageContentProvider contentProvider) {
            super(contentProvider.getId());
            this._contentProvider = null;
            this._folder = null;
            this._containers = new ArrayList();
            this._consultMode = false;
            this._isEnabled = true;
            this.foreground = null;
            this._contentProvider = contentProvider;
            this.setTitle(contentProvider.getPageTitle());
            this.setDescription(contentProvider.getPageDescription());
            this.setPageComplete(false);
        }

        public EditorPage(IPageContentProvider contentProvider, ImageDescriptor titleImage) {
            super(contentProvider.getId(), contentProvider.getPageTitle(), titleImage);
            this._contentProvider = null;
            this._folder = null;
            this._containers = new ArrayList();
            this._consultMode = false;
            this._isEnabled = true;
            this.foreground = null;
            this._contentProvider = contentProvider;
            this.setDescription(contentProvider.getPageDescription());
            this.setPageComplete(false);
        }

        public IPageContentProvider getContentProvider() {
            return this._contentProvider;
        }

        public EClass getElementType() {
            return this._contentProvider.getElementType();
        }

        public void createControl(Composite parent) {
            ITabDescriptor[] descriptors = this._contentProvider.getTabDescriptors();
            if (descriptors == null || descriptors.length == 0) {
                return;
            }
            this._folder = new TabFolder(parent, 128);
            int i = 0;
            while (i < descriptors.length) {
                ITabDescriptor descriptor = descriptors[i];
                TabItem tabItem = new TabItem(this._folder, 0);
                tabItem.setText(descriptor.getLabel());
                FieldsViewer content = descriptor.getContent((Composite)this._folder);
                if (content != null) {
                    content.setStore(Editor.this.store);
                    content.setPage((DialogPage)this);
                    content.load();
                    this._containers.add(content);
                    tabItem.setControl((Control)content.getControl());
                    if (this._consultMode) {
                        content.setEnabled(false);
                    }
                }
                ++i;
            }
            this.setControl((Control)this._folder);
        }

        public void load() {
            for (FieldsViewer composite : this._containers) {
                composite.load();
            }
        }

        public void store() {
            for (FieldsViewer composite : this._containers) {
                composite.store();
            }
        }

        public void setConsultMode(boolean consult) {
            this._consultMode = consult;
        }

        public boolean isConsultMode() {
            return this._consultMode;
        }

        public void setEnabled(boolean enabled) {
            if (!this._consultMode) {
                this._isEnabled = enabled;
                if (this._folder != null) {
                    int i = 0;
                    while (i < this._folder.getItemCount()) {
                        TabItem tab = this._folder.getItem(i);
                        tab.getControl().setEnabled(enabled);
                        ++i;
                    }
                }
            }
        }

        public boolean isEnabled() {
            return this._isEnabled;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("field_editor_is_valid".equals(event.getProperty())) {
                if (event.getSource() instanceof MdeFieldEditor) {
                    MdeFieldEditor field = (MdeFieldEditor)event.getSource();
                    if (((Boolean)event.getNewValue()).booleanValue()) {
                        if (field.getValueControl() != null && this.foreground != null) {
                            field.getValueControl().setForeground(this.foreground);
                            this.foreground = null;
                        }
                    } else if (field.getValueControl() != null) {
                        this.foreground = field.getValueControl().getForeground();
                        field.getValueControl().setForeground(Display.getDefault().getSystemColor(3));
                    }
                }
                this.setPageComplete(this.getErrorMessage() == null);
            }
        }
    }
}

