/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.provider;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.common.platform.sirius.ted.SiriusSessionListener;
import org.polarsys.capella.common.ui.toolkit.provider.Messages;

public class GroupedAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    protected ResourceSetListener listener = null;
    protected Collection<Notification> notifications = null;
    protected Collection<EObject> toRefresh = new HashSet<EObject>();

    public GroupedAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected ResourceSetListener getListener() {
        if (this.listener == null) {
            this.listener = new ResourceSetListenerImpl(){

                public boolean isPostcommitOnly() {
                    return true;
                }

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    super.resourceSetChanged(event);
                    if (GroupedAdapterFactoryContentProvider.this.refreshRequired(event)) {
                        GroupedAdapterFactoryContentProvider.this.runRefresh();
                    }
                }
            };
        }
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshRequired(ResourceSetChangeEvent event) {
        if (SiriusSessionListener.isOpeningSession((EditingDomain)event.getEditingDomain())) {
            return false;
        }
        if (SiriusSessionListener.isClosingSession((EditingDomain)event.getEditingDomain())) {
            return false;
        }
        boolean shouldRefresh = true;
        GroupedAdapterFactoryContentProvider groupedAdapterFactoryContentProvider = this;
        synchronized (groupedAdapterFactoryContentProvider) {
            shouldRefresh = this.notifications != null && this.notifications.size() > 0 || this.toRefresh != null && this.toRefresh.size() > 0;
        }
        return shouldRefresh;
    }

    public void notifyChanged2(Notification notification) {
        if (notification instanceof IViewerNotification) {
            this.viewerRefresh.addNotification((IViewerNotification)notification);
        } else {
            new NotifyChangedToViewerRefresh().refresh(this.viewer, notification.getNotifier(), notification.getEventType(), notification.getFeature(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
        }
    }

    public void runRefresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            UIJob job = new UIJob(this.viewer.getControl().getDisplay(), Messages.GroupedAdapterFactoryContentProvider_RefreshViewer){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    GroupedAdapterFactoryContentProvider.this.processRefresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRefresh() {
        Collection<Notification> currentNotifications = null;
        Collection<EObject> currentRefresh = null;
        GroupedAdapterFactoryContentProvider groupedAdapterFactoryContentProvider = this;
        synchronized (groupedAdapterFactoryContentProvider) {
            currentNotifications = this.notifications;
            this.notifications = null;
            currentRefresh = this.toRefresh;
            this.toRefresh = null;
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            HashSet<ChangeNotification> duplicateNotifications = new HashSet<ChangeNotification>();
            if (currentNotifications != null && currentNotifications.size() > 0) {
                this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh(this.viewer);
                for (Notification notification : currentNotifications) {
                    ChangeNotification changeNotification = new ChangeNotification(notification);
                    if (duplicateNotifications.contains(changeNotification)) continue;
                    duplicateNotifications.add(changeNotification);
                    this.notifyChanged2(notification);
                }
                duplicateNotifications.clear();
                if (this.viewerRefresh != null) {
                    this.viewerRefresh.run();
                    this.viewerRefresh = null;
                }
                currentNotifications.clear();
            }
            if (currentRefresh != null && currentRefresh.size() > 0) {
                ((StructuredViewer)this.viewer).update(currentRefresh.toArray(), null);
                currentRefresh.clear();
            }
        }
    }

    public synchronized void addNotification(Notification notification) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.add(notification);
    }

    protected synchronized void addNotifications(List<Notification> notifications) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.addAll(notifications);
    }

    public synchronized void addObject(EObject eObject) {
        if (this.toRefresh == null) {
            this.toRefresh = new HashSet<EObject>();
        }
        this.toRefresh.add(eObject);
    }

    public void notifyChanged(Notification notification) {
        this.addNotification(notification);
    }

    protected class ChangeNotification {
        private WeakReference<Object> _notifierReference;
        private WeakReference<Object> _featureReference;
        private WeakReference<Object> _newValueReference;
        private WeakReference<Object> _element;
        private int _eventType;

        @Deprecated
        public ChangeNotification(Object notifier, Object feature, Object newValue, int eventType) {
            this._notifierReference = new WeakReference<Object>(notifier);
            this._featureReference = new WeakReference<Object>(feature);
            this._newValueReference = new WeakReference<Object>(newValue);
            this._eventType = eventType;
        }

        public ChangeNotification(Notification notification) {
            this(notification.getNotifier(), notification.getFeature(), notification.getNewValue(), notification.getEventType());
            if (notification instanceof ViewerNotification) {
                this._element = new WeakReference<Object>(((ViewerNotification)notification).getElement());
            }
        }

        public boolean equals(Object object) {
            boolean cr = super.equals(object);
            if (!cr && object instanceof ChangeNotification) {
                ChangeNotification notification = (ChangeNotification)object;
                cr = true;
                if (!(this._notifierReference.get() == null && notification._notifierReference.get() == null || this._notifierReference.get() != null && this._notifierReference.get().equals(notification._notifierReference.get()))) {
                    cr = false;
                } else if (!(this._featureReference.get() == null && notification._featureReference.get() == null || this._featureReference.get() != null && this._featureReference.get().equals(notification._featureReference.get()))) {
                    cr = false;
                } else if (!(this._newValueReference.get() == null && notification._newValueReference.get() == null || this._newValueReference.get() != null && this._newValueReference.get().equals(notification._newValueReference.get()))) {
                    cr = false;
                } else if (!(this._element == null || this._element.get() == null && notification._element.get() == null || this._element.get() != null && this._element.get().equals(notification._element.get()))) {
                    cr = false;
                }
                cr = cr ? this._eventType == notification._eventType : false;
            }
            return cr;
        }

        public int hashCode() {
            int result = 17;
            if (this._notifierReference.get() != null) {
                result = 37 * result + this._notifierReference.get().hashCode();
            }
            if (this._featureReference.get() != null) {
                result = 37 * result + this._featureReference.get().hashCode();
            }
            if (this._newValueReference.get() != null) {
                result = 37 * result + this._newValueReference.get().hashCode();
            }
            if (this._element != null && this._element.get() != null) {
                result = 37 * result + this._element.get().hashCode();
            }
            result = 37 * result + this._eventType;
            return result;
        }
    }
}

