/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractCompoundCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.re.ReNamedElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.utils.saxparser.WriteCapellaElementDescriptionSAXParser;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.ui.search.CommandFactory;
import org.polarsys.capella.core.ui.search.FindAndReplaceHeader;
import org.polarsys.capella.core.ui.search.Messages;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;
import org.polarsys.kitalpha.emde.model.Element;

public class FindAndReplaceDialog
extends SelectElementsDialog {
    private static final String SPACE = " ";
    private Pattern pattern;
    private static final int REPLACE_ALL_BUTTON = 1025;
    private static final int COMPUTE_IMPACT_BUTTON = 1026;
    private FindAndReplaceHeader header;
    private ISelection currentSelection;
    private Predicate<Element> isNameMatching;
    private Predicate<Element> isSummaryMatching;
    private Predicate<Element> isDescriptionMatching;
    boolean ignoreWildCards;
    private boolean wholeExpression;
    private boolean wholeModelSearch;
    private boolean nameSearch;
    private boolean summarySearch;
    private boolean descriptionSearch;
    private SystemEngineering systemEngineering;
    private Set<Element> scope;
    private Set<Element> matchingElementsForName;
    private Set<Element> matchingElementsForSummary;
    private Set<Element> matchingElementsForDescription;
    private boolean updateHyperlinks;
    private boolean ignoreCase;
    private Predicate<CapellaElement> isDescriptionMatchingByWords;

    protected FindAndReplaceDialog(Shell parentShell, Collection<? extends EObject> elements, int treeViewerExpandLevel) {
        super(parentShell, TransactionHelper.getEditingDomain(elements), CapellaAdapterFactoryProvider.getInstance().getAdapterFactory(), Messages.FindAndReplaceDialog_title, Messages.FindAndReplaceDialog_dialogMessage, elements, true, null, treeViewerExpandLevel);
    }

    public FindAndReplaceDialog(Shell shell, SystemEngineering root, HashSet<EObject> modelElementContent, ISelection selection, int treeViewerExpandLevel) {
        this(shell, modelElementContent, treeViewerExpandLevel);
        this.currentSelection = selection;
        this.systemEngineering = root;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button reportImpactButton = this.createButton(parent, 1026, Messages.FindAndReplaceDialog_compute_impact, false);
        Button replaceAllButton = this.createButton(parent, 1025, Messages.FindAndReplaceDialog_replace_all, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        reportImpactButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.handlePreviewImpact();
            }
        });
        replaceAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.handleReplaceAll(e.getSource());
            }
        });
    }

    protected void doCreateDialogArea(Composite parent) {
        this.header = new FindAndReplaceHeader(parent, 262144);
        super.doCreateDialogArea(parent);
        this.getViewer().getClientViewer().setSelection(this.currentSelection, true);
        this.getViewer().getClientViewer().getTree().showSelection();
        this.isNameMatching = new Predicate<Element>(){

            public boolean apply(Element elt) {
                if (elt instanceof AbstractNamedElement) {
                    return FindAndReplaceDialog.this.match(((AbstractNamedElement)elt).getName());
                }
                if (elt instanceof ReNamedElement) {
                    return FindAndReplaceDialog.this.match(((ReNamedElement)elt).getName());
                }
                return false;
            }
        };
        this.isSummaryMatching = new Predicate<Element>(){

            public boolean apply(Element elt) {
                return elt instanceof CapellaElement ? FindAndReplaceDialog.this.match(((CapellaElement)elt).getSummary()) : false;
            }
        };
        this.isDescriptionMatching = new Predicate<Element>(){

            public boolean apply(Element elt) {
                return elt instanceof CapellaElement ? FindAndReplaceDialog.this.match(((CapellaElement)elt).getDescription()) : false;
            }
        };
        this.isDescriptionMatchingByWords = new Predicate<CapellaElement>(){

            public boolean apply(CapellaElement elt) {
                String description = elt.getDescription();
                if (description == null) {
                    return false;
                }
                List<String> words = Arrays.asList(description.split(FindAndReplaceDialog.SPACE));
                for (String word : words) {
                    if (!FindAndReplaceDialog.this.match(word)) continue;
                    return true;
                }
                return false;
            }
        };
        this.matchingElementsForSummary = Sets.newHashSet();
        this.matchingElementsForName = Sets.newHashSet();
        this.matchingElementsForDescription = Sets.newHashSet();
        this.header.getWholeModelRadioButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.getViewer().setEnabled(false);
            }
        });
        this.header.getSelectedElementsRadioBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindAndReplaceDialog.this.getViewer().setEnabled(true);
            }
        });
    }

    private void getUserChoices() {
        this.ignoreWildCards = !this.header.isWildCardsChecked();
        this.ignoreCase = !this.header.isCaseSensitiveChecked();
        this.wholeModelSearch = this.header.isWholeModelChecked();
        this.wholeExpression = this.header.isWholeExpression();
        this.nameSearch = this.header.isNameChecked();
        this.summarySearch = this.header.isSummaryChecked();
        this.descriptionSearch = this.header.isDescriptionChecked();
        this.updateHyperlinks = this.header.isUpdateHyperlinks();
    }

    void handlePreviewImpact() {
        this.getUserChoices();
        this.updateScope();
        this.updatePattern();
        this.updateMatchingElements();
        this.header.getImpactedElementsLabel().setText(String.valueOf(this.matchingElementsForName.size()) + SPACE);
        this.header.getNbImpactedSummaries().setText(String.valueOf(this.matchingElementsForSummary.size()) + SPACE);
        this.header.getNbImpactedDescs().setText(String.valueOf(this.matchingElementsForDescription.size()) + SPACE);
        Sets.SetView impactedElts = Sets.union((Set)Sets.union(this.matchingElementsForName, this.matchingElementsForSummary), this.matchingElementsForDescription);
        if (impactedElts.size() == 0) {
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)Messages.FindAndReplaceDialog_title, (String)Messages.FindAndReplaceDialog_no_matching);
        }
        if (impactedElts.size() > 0) {
            ImpactAnalysisDialog impactDialog = new ImpactAnalysisDialog(new ArrayList(impactedElts), Messages.FindAndReplaceDialog_preview, NLS.bind((String)Messages.FindAndReplaceDialog_impacted_find_string, (Object)this.getFindString()));
            PreviewDialogContextMenuFiller contextMenuFiller = new PreviewDialogContextMenuFiller();
            impactDialog.setContextMenuManagerFiller((AbstractContextMenuFiller)contextMenuFiller);
            impactDialog.open();
        }
    }

    void handleReplaceAll(Object source) {
        this.getUserChoices();
        this.updateScope();
        this.updatePattern();
        this.updateMatchingElements();
        ICommand replaceAllInNameCmd = CommandFactory.createReplaceAllInNameCommand(this.matchingElementsForName, this.getFindString(), this.getReplaceString(), false, this.ignoreWildCards, false, false);
        ICommand replaceAllInSummaryCmd = CommandFactory.createReplaceAllInSummary(this.matchingElementsForSummary, this.getFindString(), this.getReplaceString(), false, this.ignoreWildCards, false, false);
        ICommand replaceAllInDescCmd = CommandFactory.createReplaceAllInDescription(this.matchingElementsForDescription, this.getFindString(), this.getReplaceString(), false, this.ignoreWildCards, false, false);
        CompoundCommand replaceAllCommand = new CompoundCommand();
        replaceAllCommand.append(replaceAllInNameCmd);
        replaceAllCommand.append(replaceAllInSummaryCmd);
        replaceAllCommand.append(replaceAllInDescCmd);
        if (replaceAllCommand.getContainedCommandsSize() > 0) {
            TransactionHelper.getExecutionManager((EObject)this.systemEngineering).execute((ICommand)replaceAllCommand);
        }
        if (this.updateHyperlinks) {
            this.updateHyperlinksInDescriptions();
        }
        this.reportResults(Messages.FindAndReplaceDialog_impacted_names, this.matchingElementsForName);
        this.reportResults(Messages.FindAndReplaceDialog_impacted_summaries, this.matchingElementsForSummary);
        this.reportResults(Messages.FindAndReplaceDialog_impacted_descriptions, this.matchingElementsForDescription);
    }

    private void updateHyperlinksInDescriptions() {
        final Set SysEngAllContents = (Set)EcoreUtil2.getAllContents(Collections.singleton(this.systemEngineering));
        final WriteCapellaElementDescriptionSAXParser writeDescription = new WriteCapellaElementDescriptionSAXParser(){

            protected String getName(EObject object) {
                DRepresentation res;
                String repName;
                String result = super.getName(object);
                if ((result == null || result.isEmpty()) && object instanceof DRepresentation && (repName = (res = (DRepresentation)object).getName()) != null) {
                    result = repName;
                }
                return result;
            }

            protected boolean managedObject(EObject object) {
                return super.managedObject(object) || object instanceof DRepresentation;
            }
        };
        AbstractReadWriteCommand updateHyperlinksCommand = new AbstractReadWriteCommand(){

            public void run() {
                writeDescription.updateDescription(new ArrayList(SysEngAllContents));
            }
        };
        TransactionHelper.getExecutionManager((Collection)SysEngAllContents).execute((ICommand)updateHyperlinksCommand);
    }

    private void updateMatchingElements() {
        this.matchingElementsForName = this.nameSearch ? ImmutableSet.copyOf((Collection)Sets.filter(this.scope, this.isNameMatching)) : Collections.emptySet();
        this.matchingElementsForSummary = this.summarySearch ? ImmutableSet.copyOf((Collection)Sets.filter(this.scope, this.isSummaryMatching)) : Collections.emptySet();
        this.matchingElementsForDescription = this.descriptionSearch ? ImmutableSet.copyOf((Collection)Sets.filter(this.scope, this.isDescriptionMatching)) : Collections.emptySet();
    }

    private void updatePattern() {
        if (!this.ignoreWildCards) {
            return;
        }
        this.pattern = this.ignoreWildCards ? Pattern.compile(this.getFindString(), (this.ignoreCase ? 2 : 0) | 0x10) : Pattern.compile(this.getFindString(), this.ignoreCase ? 2 : 0);
    }

    private void updateScope() {
        if (this.wholeModelSearch) {
            this.scope = (Set)EcoreUtil2.getAllContents(Collections.singleton(this.systemEngineering));
        } else {
            List selected = this.handleResult();
            this.scope = (Set)EcoreUtil2.getAllContents((Collection)selected);
        }
    }

    public String getFindString() {
        String findText = this.header.getFindCombo().getText();
        return findText;
    }

    public String getReplaceString() {
        return this.header.getReplaceCombo().getText();
    }

    boolean match(String string) {
        if (string == null) {
            return false;
        }
        if (!this.ignoreWildCards) {
            return this.matchWithWildCard(string);
        }
        if (this.wholeExpression) {
            List<String> findExprList = Arrays.asList(this.getFindString().split(SPACE));
            List<String> string_pList = Arrays.asList(string.split(SPACE));
            return FindAndReplaceDialog.matchExpressionList(string_pList, findExprList, this.ignoreCase);
        }
        return this.pattern.matcher(string).find();
    }

    private boolean matchWithWildCard(String string) {
        StringMatcher wildCardMatcher = new StringMatcher(this.getFindString(), this.ignoreCase, this.ignoreWildCards);
        return wildCardMatcher.match(string);
    }

    public static boolean matchExpressionList(List<String> text, List<String> findExpr, boolean ignoreCase) {
        if (text == null | findExpr == null) {
            return false;
        }
        int textSize = text.size();
        int findExprSize = findExpr.size();
        if (findExprSize > textSize) {
            return false;
        }
        int i = 0;
        while (i < textSize) {
            if (FindAndReplaceDialog.areEquals(findExpr.get(0), text.get(i), ignoreCase)) {
                List<String> textSubList = text.subList(i + 1, i + findExprSize);
                List<String> fExprSublist = findExpr.subList(1, findExprSize);
                if (FindAndReplaceDialog.areEquals(fExprSublist, textSubList, ignoreCase)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean areEquals(List<String> l1, List<String> l2, boolean ignoreCase) {
        if (l2.size() != l1.size()) {
            return false;
        }
        if (ignoreCase) {
            int i = 0;
            while (i < l2.size()) {
                if (!l1.get(i).equalsIgnoreCase(l2.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return l1.equals(l2);
        }
        return true;
    }

    private static boolean areEquals(String string, String string2, boolean ignoreCase) {
        if (ignoreCase) {
            return string2.equalsIgnoreCase(string);
        }
        return string2.equals(string);
    }

    private void reportResults(String message, Set<Element> impactedElements) {
        int impactedCount = impactedElements.size();
        String informationMessage = NLS.bind((String)message, (Object)impactedCount);
        LightMarkerRegistry.getInstance().createMarker((IResource)ResourcesPlugin.getWorkspace().getRoot(), (Diagnostic)new BasicDiagnostic(Messages.FindAndReplaceDialog_1, 0, informationMessage, impactedElements.toArray()));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview", null, 2);
        }
        catch (PartInitException exception) {
            MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception.getLocalizedMessage(), (Throwable)exception));
        }
    }

    class CompoundCommand
    extends AbstractCompoundCommand {
        CompoundCommand() {
        }

        public void append(ICommand command) {
            if (command != null) {
                super.append(command);
            }
        }
    }

    protected final class PreviewDialogContextMenuFiller
    extends AbstractContextMenuFiller {
        protected PreviewDialogContextMenuFiller() {
        }

        public void fillMenuManager(IMenuManager contextMenuManager, final ISelection selection) {
            final LocateInCapellaExplorerAction selectInExplorerAction = new LocateInCapellaExplorerAction(){

                protected ISelection getSelection() {
                    return selection;
                }
            };
            Action action = new Action(){

                public void run() {
                    selectInExplorerAction.run((IAction)this);
                }
            };
            selectInExplorerAction.shouldIgnoreWorkbenchPartSite(true);
            action.setText(Messages.ImpactAnalysisAction_ShowInCapellaExplorer_Title);
            action.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
            selectInExplorerAction.selectionChanged((IAction)action, selection);
            if (action.isEnabled()) {
                contextMenuManager.add((IAction)action);
            }
            final EObject eObject = (EObject)((TreeSelection)selection).iterator().next();
            final LocateInCapellaExplorerAction selectInSemanticBrowserAction = new LocateInCapellaExplorerAction(){

                protected ISelection getSelection() {
                    return selection;
                }
            };
            Action action3 = new Action(){

                public void run() {
                    try {
                        this.activateSemanticBrowser();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    selectInSemanticBrowserAction.run((IAction)this);
                }

                private void activateSemanticBrowser() throws CoreException {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    SemanticBrowserView smView = (SemanticBrowserView)activePage.findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                    if (smView == null) {
                        smView = (SemanticBrowserView)activePage.showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                    }
                    activePage.activate((IWorkbenchPart)smView);
                    smView.setInput((Object)eObject);
                }
            };
            selectInSemanticBrowserAction.shouldIgnoreWorkbenchPartSite(true);
            action3.setText(Messages.selectInSemanticBrowser);
            action3.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
            selectInSemanticBrowserAction.selectionChanged((IAction)action3, selection);
            if (action3.isEnabled()) {
                contextMenuManager.add((IAction)action3);
            }
        }
    }
}

