/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.Messages;
import org.polarsys.capella.core.data.migration.MigrationJobScheduler;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.IMigrationContribution;
import org.polarsys.capella.core.data.migration.contributor.AbstractMigrationContributor;
import org.xml.sax.Attributes;

public class MigrationHelpers
implements IMigrationContribution {
    private static MigrationHelpers INSTANCE = null;
    private ArrayList<AbstractMigrationContributor> contributors = null;
    private ArrayList<IMigrationContribution> migrations = new ArrayList();
    static final String MIGRATION_CONTRIBUTIONS_ID = "org.polarsys.capella.core.data.migration.contributions";
    static final String MIGRATION_CONTRIBUTORS_ID = "org.polarsys.capella.core.data.migration.contributors";

    public MigrationHelpers() {
        IConfigurationElement configElement;
        IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.data.migration", (String)"migrationContributions");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            configElement = iConfigurationElementArray[n2];
            IMigrationContribution contribution = (IMigrationContribution)ExtensionPointHelper.createInstance((IConfigurationElement)configElement, (String)"class");
            this.migrations.add(contribution);
            ++n2;
        }
        this.contributors = new ArrayList();
        iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.data.migration", (String)"migrationContributors");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            configElement = iConfigurationElementArray[n2];
            AbstractMigrationContributor contributor = (AbstractMigrationContributor)ExtensionPointHelper.createInstance((IConfigurationElement)configElement, (String)"class");
            this.contributors.add(contributor);
            ++n2;
        }
    }

    public void trigger(IResource resource, Shell shell, boolean skipConfirmation, boolean checkVersion, String[] kinds) {
        this.trigger(resource, shell, true, skipConfirmation, checkVersion, kinds);
    }

    public void trigger(IResource resource, Shell shell, boolean runInJob, boolean skipConfirmation, boolean checkVersion, String[] kinds) {
        LinkedHashSet<IResource> files = new LinkedHashSet<IResource>();
        LinkedList<AbstractMigrationContributor> currentContributors = new LinkedList<AbstractMigrationContributor>();
        String[] stringArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            String kind = stringArray[n2];
            for (AbstractMigrationContributor contributor : this.contributors) {
                if (!contributor.getKind().equals(kind)) continue;
                currentContributors.add(contributor);
            }
            ++n2;
        }
        for (AbstractMigrationContributor contributor : currentContributors) {
            files.addAll(contributor.getMigrableFiles(resource));
        }
        MigrationContext context = new MigrationContext();
        context.setName(NLS.bind((String)Messages.MigrationAction_Title, (Object)resource.getName()));
        context.setShell(shell);
        context.setSkipConfirmation(skipConfirmation);
        LinkedList<AbstractMigrationRunnable> runnables = new LinkedList<AbstractMigrationRunnable>();
        for (AbstractMigrationContributor contributor : currentContributors) {
            for (IResource file : files) {
                if (!contributor.isValidResource(file)) continue;
                AbstractMigrationRunnable runnable = contributor.getRunnable((IFile)file);
                runnables.add(runnable);
            }
        }
        new MigrationJobScheduler().run(runnables, context, runInJob, checkVersion);
    }

    public static MigrationHelpers getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MigrationHelpers();
        }
        return INSTANCE;
    }

    @Override
    public void dispose(ExecutionManager manager, ResourceSet resourceSet, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            try {
                migration.dispose(manager, resourceSet, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dispose(MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            try {
                migration.dispose(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getFeatureName(String prefix, String name, boolean isElement, EObject peekObject, String value, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            String newFeatureName = migration.getFeatureName(prefix, name, isElement, peekObject, value, resource, context);
            if (newFeatureName == null) continue;
            return newFeatureName;
        }
        return null;
    }

    @Override
    public EStructuralFeature getFeature(EObject peekObject, EStructuralFeature feature, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            EStructuralFeature newFeature = migration.getFeature(peekObject, feature, resource, context);
            if (newFeature == null) continue;
            return newFeature;
        }
        return null;
    }

    @Override
    public String getQName(EObject peekObject, String typeQName, EStructuralFeature feature, Resource resource, XMLHelper helper, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            String qName = migration.getQName(peekObject, typeQName, feature, resource, helper, context);
            if (qName == null) continue;
            return qName;
        }
        return null;
    }

    @Override
    public EFactory getEFactory(String prefix, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            EFactory newEFactory = migration.getEFactory(prefix, resource, context);
            if (newEFactory == null) continue;
            return newEFactory;
        }
        return null;
    }

    @Override
    public void updateElement(EObject peekObject, String typeName, EObject result, EStructuralFeature feature, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.updateElement(peekObject, typeName, result, feature, resource, context);
        }
    }

    @Override
    public IStatus preMigrationExecute(IResource fileToMigrate, MigrationContext context, boolean checkVersion) {
        for (IMigrationContribution migration : this.migrations) {
            IStatus status = migration.preMigrationExecute(fileToMigrate, context, checkVersion);
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        for (Resource resource : resourceSet.getResources()) {
            for (IMigrationContribution migration : this.migrations) {
                migration.unaryStartMigrationExecute(executionManager, resource, context);
            }
            TreeIterator iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                EObject currentElement = (EObject)iterator.next();
                for (IMigrationContribution migration : this.migrations) {
                    migration.unaryMigrationExecute(currentElement, context);
                }
            }
            for (IMigrationContribution migration : this.migrations) {
                migration.unaryEndMigrationExecute(executionManager, resource, context);
            }
        }
        for (IMigrationContribution migration : this.migrations) {
            migration.postMigrationExecute(executionManager, resourceSet, context);
        }
    }

    @Override
    public void postMigrationExecuteCommands(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.postMigrationExecuteCommands(executionManager, resourceSet, context);
        }
    }

    @Override
    public String getNSPrefix(String prefix, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            String newPrefix = migration.getNSPrefix(prefix, context);
            if (newPrefix == null) continue;
            return newPrefix;
        }
        return null;
    }

    @Override
    public String getNSURI(String prefix, String nsUri, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            String newPrefix = migration.getNSURI(prefix, nsUri, context);
            if (newPrefix == null) continue;
            return newPrefix;
        }
        return null;
    }

    @Override
    public Object getValue(EObject peekObject, EStructuralFeature feature, Object value, int position, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            Object newValue = migration.getValue(peekObject, feature, value, position, resource, context);
            if (newValue == null) continue;
            return newValue;
        }
        return null;
    }

    @Override
    public void contributePackageRegistry(EPackage.Registry packageRegistry, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.contributePackageRegistry(packageRegistry, context);
        }
    }

    @Override
    public void preSaveResource(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.preSaveResource(executionManager, resource, context);
        }
    }

    public void onOutOfMemoryError(OutOfMemoryError error, final MigrationContext context) {
        Display display;
        Shell shell;
        if (!(context.isSkipConfirmation() || (shell = context.getShell()) == null || shell.isDisposed() || (display = shell.getDisplay()) == null || display.isDisposed())) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)context.getShell(), (String)Messages.ECore2ECoreMigrationAction_Migration_OutOfMemoryError_Title, (String)Messages.ECore2ECoreMigrationAction_Migration_OutOfMemoryError_Description);
                }
            });
        }
    }

    @Override
    public void unaryStartMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.unaryStartMigrationExecute(executionManager, resource, context);
        }
    }

    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.unaryMigrationExecute(currentElement, context);
        }
    }

    @Override
    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.unaryEndMigrationExecute(executionManager, resource, context);
        }
    }

    @Override
    public void newResource(Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.newResource(resource, context);
        }
    }

    @Override
    public String getHandleProxy(InternalEObject proxy, String uriLiteral, Resource resource, XMLHelper helper, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            String result = migration.getHandleProxy(proxy, uriLiteral, resource, helper, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IStatus handleError(XMIException e, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            IStatus result = migration.handleError(e, resource, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void endElement(EObject peekEObject, Attributes attribs, String uri, String localName, String name, Resource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            migration.endElement(peekEObject, attribs, uri, localName, name, resource, context);
        }
    }

    @Override
    public boolean ignoreSetFeatureValue(EObject peekObject, EStructuralFeature feature, Object value, int position, XMLResource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            if (!migration.ignoreSetFeatureValue(peekObject, feature, value, position, resource, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean ignoreUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value, XMLResource resource, MigrationContext context) {
        for (IMigrationContribution migration : this.migrations) {
            if (!migration.ignoreUnknownFeature(prefix, name, isElement, peekObject, value, resource, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createdXMLHelper(XMLResource resource, XMLHelper result) {
        for (IMigrationContribution migration : this.migrations) {
            migration.createdXMLHelper(resource, result);
        }
    }
}

