/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.aird;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileVersionSAXParser;
import org.eclipse.sirius.business.internal.resource.AirDResourceImpl;
import org.eclipse.sirius.business.internal.resource.parser.RepresentationsFileXMIHelper;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.core.data.migration.aird.Messages;
import org.polarsys.capella.core.data.migration.capella.ModelMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.kitalpha.emde.xmi.XMIExtensionHelperImpl;

public class AirdMigrationRunnable
extends ModelMigrationRunnable {
    static final String FORMAT_UTF8 = "UTF-8";

    public AirdMigrationRunnable(IFile file) {
        super(file);
    }

    @Override
    public String getName() {
        return Messages.MigrationAction_DiagramMigration;
    }

    static boolean isAirdFile(URI uri) {
        boolean res = uri != null && ("aird".equals(uri.fileExtension()) || "airdfragment".equals(uri.fileExtension()));
        return res;
    }

    @Override
    public XMLResource doCreateResource(URI uri, final MigrationContext context) {
        if (AirdMigrationRunnable.isAirdFile(uri)) {
            AirDResourceImpl result = new AirDResourceImpl(uri){

                protected XMIExtensionHelperImpl createXMLHelper() {
                    return AirdMigrationRunnable.this.createCapellaXMLHelper((XMLResource)this);
                }

                protected XMLLoad createXMLLoad() {
                    return AirdMigrationRunnable.this.createCustomizedHandler(this.createXMLHelper(), context);
                }

                protected XMLLoad createXMLLoad(Map<?, ?> options) {
                    return this.createXMLLoad();
                }

                protected void init() {
                    super.init();
                    RepresentationsFileVersionSAXParser parser = new RepresentationsFileVersionSAXParser(this.getURI());
                    String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
                    this.getDefaultLoadOptions().put("VERSION", loadedVersion);
                    this.getDefaultSaveOptions().put("ENCODING", AirdMigrationRunnable.FORMAT_UTF8);
                    this.getDefaultLoadOptions().put("ENCODING", AirdMigrationRunnable.FORMAT_UTF8);
                    this.getDefaultSaveOptions().put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
                    this.getDefaultSaveOptions().put("USE_FILE_BUFFER", Boolean.TRUE);
                    this.getDefaultSaveOptions().put("FLUSH_THRESHOLD", 0x1000000);
                    this.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    AirDResourceImpl.addMigrationOptions((String)loadedVersion, (Map)this.getDefaultLoadOptions(), (Map)this.getDefaultSaveOptions());
                    if (!this.getEncoding().equals(AirdMigrationRunnable.FORMAT_UTF8)) {
                        this.setEncoding(AirdMigrationRunnable.FORMAT_UTF8);
                    }
                }
            };
            return result;
        }
        return super.doCreateResource(uri, context);
    }

    @Override
    public XMIExtensionHelperImpl createCapellaXMLHelper(XMLResource resource) {
        final RepresentationsFileXMIHelper delegateXMLHelper = new RepresentationsFileXMIHelper(resource);
        XMIExtensionHelperImpl result = new XMIExtensionHelperImpl(resource){

            public EClassifier getType(EFactory eFactory, String typeName) {
                EClassifier type = null;
                if (eFactory != null) {
                    EPackage ePackage = eFactory.getEPackage();
                    if (this.extendedMetaData != null) {
                        type = this.extendedMetaData.getType(ePackage, typeName);
                    }
                    if (type == null) {
                        EClass eClass = (EClass)ePackage.getEClassifier(typeName);
                        if (eClass == null && this.xmlMap != null) {
                            return this.xmlMap.getClassifier(ePackage.getNsURI(), typeName);
                        }
                        return eClass;
                    }
                }
                return type;
            }

            public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
                super.setValue(object, feature, value, position);
            }

            public EObject createObject(EFactory eFactory, EClassifier type) {
                return delegateXMLHelper.createObject(eFactory, type);
            }

            public URI deresolve(URI uri) {
                return delegateXMLHelper.deresolve(uri);
            }

            public String convertToString(EFactory factory, EDataType dataType, Object value) {
                return delegateXMLHelper.convertToString(factory, dataType, value);
            }

            protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
                if (value != null && eDataType.equals(ViewpointPackage.eINSTANCE.getResourceDescriptor())) {
                    URI resolvedURI = new ResourceDescriptor(value).getResourceURI().resolve(this.resourceURI);
                    return new ResourceDescriptor(resolvedURI);
                }
                return super.createFromString(eFactory, eDataType, value);
            }
        };
        return result;
    }
}

