/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class ActivateDiagramFiltersContribution
extends AbstractMigrationContribution {
    @Override
    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        super.unaryEndMigrationExecute(executionManager, resource, context);
        this.activateRelevantDiagramFilters(resource);
    }

    private void activateRelevantDiagramFilters(Resource resource) {
        for (DDiagram diagram : this.getAllLabAndPabDiagrams(resource)) {
            for (FilterDescription filter : diagram.getDescription().getFilters()) {
                if (!this.isRelevantFilter(filter.getName()) || diagram.getActivatedFilters().contains((Object)filter)) continue;
                diagram.getActivatedFilters().add((Object)filter);
            }
        }
    }

    private boolean isRelevantFilter(String filterName) {
        return "Hide Computed Component Exchanges".equals(filterName) || "Hide Computed Component Exchanges".equals(filterName) || "Hide Computed Physical Links".equals(filterName) || "Hide Computed Physical Links".equals(filterName);
    }

    private List<DDiagram> getAllLabAndPabDiagrams(Resource resource) {
        ArrayList<DDiagram> allDiagrams = new ArrayList<DDiagram>();
        if (!CapellaResourceHelper.isAirdResource((URI)resource.getURI())) {
            return Collections.emptyList();
        }
        for (EObject root : resource.getContents()) {
            DDiagram diagram;
            if (!(root instanceof DDiagram) || !"Physical Architecture Blank".equals((diagram = (DDiagram)root).getDescription().getName()) && !"Logical Architecture Blank".equals(diagram.getDescription().getName())) continue;
            allDiagrams.add((DDiagram)root);
        }
        return allDiagrams;
    }
}

