/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class FixDAnnotationsContribution
extends AbstractMigrationContribution {
    private static List<String> dAnnotationMigrationMapping = Arrays.asList("http://www.thalesgroup.com/mde/melody/NotVisibleInDoc", "http://www.thalesgroup.com/mde/melody/NotVisibleInLM", "http://www.thalesgroup.com/mde/melody/ProgressStatus", "http://www.thalesgroup.com/mde/melody/StatusReview");

    @Override
    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        super.unaryEndMigrationExecute(executionManager, resource, context);
        this.cleanDiagram(resource);
    }

    public Set<DRepresentation> cleanDiagram(Resource resource) {
        Map<DRepresentation, Integer> diagramToModifyObjectCount = this.doCleanDiagrams(resource);
        return diagramToModifyObjectCount.keySet();
    }

    protected Map<DRepresentation, Integer> doCleanDiagrams(Resource resource) {
        HashMap<DRepresentation, Integer> diagramToModifyObjectCount = new HashMap<DRepresentation, Integer>();
        for (DRepresentation representation : this.getAllRepresentations(resource)) {
            for (String oldAnnotationID : dAnnotationMigrationMapping) {
                DAnnotation oldAnnotation = RepresentationHelper.getAnnotation((String)oldAnnotationID, (DRepresentation)representation);
                if (oldAnnotation == null) continue;
                RepresentationHelper.removeAnnotation((String)oldAnnotationID, (DRepresentation)representation);
            }
        }
        return diagramToModifyObjectCount;
    }

    public List<DRepresentation> getAllRepresentations(Resource resource) {
        ArrayList<DRepresentation> allRepresentations = new ArrayList<DRepresentation>();
        if (!CapellaResourceHelper.isAirdResource((URI)resource.getURI())) {
            return Collections.emptyList();
        }
        for (EObject root : resource.getContents()) {
            if (!(root instanceof DRepresentation)) continue;
            allRepresentations.add((DRepresentation)root);
        }
        return allRepresentations;
    }
}

