/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.internal.sections;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.ChooseDialog;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableObjectManager {
    public static final int BOOL = 1;
    public static final int ENUM = 2;
    public static final int STR = 3;
    public static final int INT = 4;
    public static final int B_INT = 6;
    public static final int REF = 5;
    public static final int DBL = 7;
    private EObject inputEObject;
    private EStructuralFeature feature;
    private EClassifier type;
    private EditingDomain editingDomain;
    private ILabelProvider labelProvider;

    public TableObjectManager(EObject eObject, EStructuralFeature structuralFeature) {
        this.inputEObject = eObject;
        this.feature = structuralFeature;
        this.type = this.feature.getEType();
    }

    public void addElement() {
        this.addElement(this.createNewElement());
    }

    public void addElement(Object newElement) {
        Command command;
        if (newElement == null) {
            return;
        }
        if (newElement instanceof List) {
            List newElements = (List)newElement;
            CompoundCommand cpcmd = new CompoundCommand();
            for (Object element : newElements) {
                cpcmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, element));
            }
            command = cpcmd;
        } else {
            command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, (Object)newElement);
        }
        this.editingDomain.getCommandStack().execute(command);
    }

    public void removeElement(Object element) {
        Command removeCmd = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, (Object)element);
        this.editingDomain.getCommandStack().execute(removeCmd);
    }

    public void updateElement(Object newValue) {
        Command command;
        if (newValue == null) {
            return;
        }
        List oldValues = (List)this.inputEObject.eGet(this.feature);
        if (newValue instanceof List) {
            List newElements = (List)newValue;
            CompoundCommand cpcmd = new CompoundCommand();
            for (Object element : oldValues) {
                if (newElements.contains(element)) continue;
                cpcmd.append(RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, element));
            }
            for (Object element : newElements) {
                if (oldValues.contains(element)) continue;
                cpcmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, element));
            }
            command = cpcmd;
        } else {
            command = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, (Object)newValue, (int)oldValues.size());
        }
        this.editingDomain.getCommandStack().execute(command);
    }

    public void elementChanged(Object oldValue, Object newValue) {
        if (!oldValue.equals(newValue)) {
            Command command = null;
            if (this.feature.isMany()) {
                List list = (List)this.inputEObject.eGet(this.feature);
                int index = list.indexOf(oldValue);
                CompoundCommand cpcmd = new CompoundCommand();
                cpcmd.append(DeleteCommand.create((EditingDomain)this.editingDomain, (Object)oldValue));
                cpcmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, Collections.singleton(newValue), (int)index));
                command = cpcmd;
            } else {
                command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.inputEObject, (Object)this.feature, (Object)newValue);
            }
            this.editingDomain.getCommandStack().execute(command);
        }
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public EStructuralFeature getManagedFeature() {
        return this.feature;
    }

    public EObject getInputEObject() {
        return this.inputEObject;
    }

    public List<?> eGet() {
        if (this.feature.isMany()) {
            return (List)this.inputEObject.eGet(this.feature);
        }
        return new ArrayList(1);
    }

    public String[] getEnumLiterals() {
        EList literals = ((EEnum)this.type).getELiterals();
        String[] result = new String[literals.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((EEnumLiteral)literals.get(i)).getLiteral();
            ++i;
        }
        return result;
    }

    public Object createEnum(int value) {
        String literal = ((EEnum)this.type).getEEnumLiteral(value).getLiteral();
        return EcoreUtil.createFromString((EDataType)((EDataType)this.type), (String)literal);
    }

    private Object createNewElement() {
        Object newElement = null;
        switch (this.getEType()) {
            case 1: {
                newElement = new Boolean(false);
                break;
            }
            case 2: {
                newElement = this.createEnum(0);
                break;
            }
            case 4: {
                newElement = new Integer(0);
                break;
            }
            case 6: {
                newElement = new BigInteger("0");
                break;
            }
            case 7: {
                newElement = new Double(0.0);
                break;
            }
            case 3: {
                newElement = Messages.TableObjectManager_NewString;
                break;
            }
            case 5: {
                if (((EClass)this.type).isAbstract()) {
                    newElement = this.createObjectFromDialog();
                    break;
                }
                newElement = EcoreUtil.create((EClass)((EClass)this.type));
                break;
            }
        }
        return newElement;
    }

    public int getEType() {
        if (this.type instanceof EEnum) {
            return 2;
        }
        if (this.type instanceof EDataType) {
            Class clazz = this.type.getInstanceClass();
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return 4;
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return 7;
            }
            if (clazz == BigInteger.class) {
                return 6;
            }
            if (clazz == String.class) {
                return 3;
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return 1;
            }
            return 0;
        }
        if (this.type instanceof EClass) {
            return 5;
        }
        return 0;
    }

    public List<?> chooseObjectsFromDialog() {
        Collection choiceOfValues = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)this.inputEObject, (EClassifier)this.feature.getEType());
        Shell shell = Display.getDefault().getActiveShell();
        String displayName = Messages.TableObjectManager_ChooseObjectsToAdd;
        ArrayList choices = new ArrayList(choiceOfValues);
        FeatureEditorDialog dialog = new FeatureEditorDialog(shell, this.labelProvider, this.inputEObject, this.feature, displayName, choices);
        dialog.open();
        return dialog.getResult();
    }

    public Object createObjectFromDialog() {
        Collection descriptors = this.editingDomain.getNewChildDescriptors((Object)this.inputEObject, null);
        Object[] selection = descriptors.toArray();
        if (selection.length > 1) {
            Object[] values = new Object[selection.length];
            int i = 0;
            while (i < selection.length) {
                values[i] = ((CommandParameter)selection[i]).getEValue();
                ++i;
            }
            Shell shell = Display.getDefault().getActiveShell();
            ChooseDialog dialog = new ChooseDialog(shell, values);
            dialog.setLabelProvider(this.labelProvider);
            selection = dialog.open() == 0 ? dialog.getResult() : new Object[]{};
        }
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }
}

