/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.ui.validation.constraints;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.IAdditionalConstraint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.ValidationStatus;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractFeature;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Cardinalities;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Enumeration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.FieldMapping;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI_Field_Type;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.ui.validation.message.Messages;

public class UIFieldTypeMappingFreeValidator
implements IAdditionalConstraint {
    public boolean isObjectInScope(Object object) {
        return object instanceof UIField;
    }

    public ValidationStatus validationRules(Object data) {
        UIField uiField = (UIField)data;
        UI_Field_Type uiFieldType = uiField.getType();
        FieldMapping fieldMapping = uiField.getMapping();
        if (uiFieldType == null || fieldMapping == null) {
            return ValidationStatus.Ignored;
        }
        if (fieldMapping != null) {
            AbstractFeature abstractFeature = fieldMapping.getUI_Field_Mapped_To();
            if (abstractFeature == null) {
                return ValidationStatus.Ignored;
            }
            if (abstractFeature instanceof AbstractAssociation) {
                Cardinalities cardinalities = ((AbstractAssociation)abstractFeature).getCardinality();
                switch (cardinalities) {
                    case NOTHING_OR_MANY: 
                    case ONE_OR_MANY: {
                        return uiFieldType.equals((Object)UI_Field_Type.MULTIPLE_CHOICE_LIST) ? ValidationStatus.Ok : ValidationStatus.Error;
                    }
                    case NOTHING_OR_ONE: 
                    case ONLY_ONE: {
                        return uiFieldType.equals((Object)UI_Field_Type.SIMPLE_CHOICE_LIST) ? ValidationStatus.Ok : ValidationStatus.Error;
                    }
                }
            }
            if (abstractFeature instanceof Attribute) {
                Attribute attribute = (Attribute)abstractFeature;
                AbstractAttributeType attributeType = attribute.getOwned_type();
                if (attributeType == null) {
                    return ValidationStatus.Ignored;
                }
                String typeName = attributeType.getName();
                switch (uiFieldType) {
                    case CHECKBOX: {
                        return typeName.equals("EBoolean") ? ValidationStatus.Ok : ValidationStatus.Error;
                    }
                    case RADIOBOX: {
                        return this.checkAttributeTypeForRadioBox(attributeType) ? ValidationStatus.Ok : ValidationStatus.Error;
                    }
                    case TEXT: 
                    case TEXTAREA: 
                    case RICHTEXT: {
                        return !typeName.equals("EBoolean") && !typeName.equals("EEnumerator") ? ValidationStatus.Ok : ValidationStatus.Error;
                    }
                    case SIMPLE_CHOICE_LIST: 
                    case MULTIPLE_CHOICE_LIST: {
                        return ValidationStatus.Error;
                    }
                }
            }
        }
        return ValidationStatus.Ignored;
    }

    private boolean checkAttributeTypeForRadioBox(AbstractAttributeType type) {
        if (type instanceof LocalAttributeType) {
            Enumeration lType = ((LocalAttributeType)type).getType();
            return lType instanceof Enumeration;
        }
        if (type instanceof ExternalAttributeType) {
            EDataType eType = ((ExternalAttributeType)type).getType();
            return eType instanceof EEnum || eType.getName().equals("EEnumerator");
        }
        return false;
    }

    public String getMessage(ValidationStatus status, Object eObject) {
        UIField uiField = (UIField)eObject;
        UI_Field_Type uiFieldType = uiField.getType();
        FieldMapping fieldMapping = uiField.getMapping();
        if (uiFieldType == null || fieldMapping == null) {
            return null;
        }
        UIContainer container = (UIContainer)uiField.eContainer();
        Object[] bindings = new Object[]{container.getName(), uiField.getName(), uiFieldType.getLiteral()};
        String mainMessage = Messages.bind((String)Messages.Validation_UIField_Mapping_MainMessage, (Object[])bindings);
        String canNotBeMapped = Messages.Validation_UIField_Mapping_CanNotBeMapped;
        String mustBeMapped = Messages.Validation_UIField_Mapping_MustBeMapped;
        if (fieldMapping != null) {
            AbstractFeature abstractFeature = fieldMapping.getUI_Field_Mapped_To();
            if (abstractFeature == null) {
                return null;
            }
            if (abstractFeature instanceof AbstractAssociation) {
                if (!uiFieldType.equals((Object)UI_Field_Type.SIMPLE_CHOICE_LIST) && !uiFieldType.equals((Object)UI_Field_Type.MULTIPLE_CHOICE_LIST)) {
                    return String.valueOf(mainMessage) + canNotBeMapped + Messages.Validation_UIField_Association_Fragment1;
                }
                Cardinalities cardinalities = ((AbstractAssociation)abstractFeature).getCardinality();
                mainMessage = String.valueOf(mainMessage) + canNotBeMapped + Messages.Validation_UIField_Association_Fragment2;
                switch (cardinalities) {
                    case NOTHING_OR_MANY: 
                    case ONE_OR_MANY: {
                        String NOTHING_OR_MANY = Cardinalities.NOTHING_OR_MANY.getLiteral();
                        String ONE_OR_MANY = Cardinalities.ONE_OR_MANY.getLiteral();
                        return String.valueOf(mainMessage) + Messages.bind((String)Messages.Validation_UIField_Association_Cardinalities, (Object)NOTHING_OR_MANY, (Object)ONE_OR_MANY);
                    }
                    case NOTHING_OR_ONE: 
                    case ONLY_ONE: {
                        String NOTHING_OR_ONE = Cardinalities.NOTHING_OR_ONE.getLiteral();
                        String ONLY_ONE = Cardinalities.ONLY_ONE.getLiteral();
                        return String.valueOf(mainMessage) + Messages.bind((String)Messages.Validation_UIField_Association_Cardinalities, (Object)NOTHING_OR_ONE, (Object)ONLY_ONE);
                    }
                }
            }
            if (abstractFeature instanceof Attribute) {
                switch (uiFieldType) {
                    case CHECKBOX: {
                        return String.valueOf(mainMessage) + mustBeMapped + Messages.Validation_UIField_Attribute_Boolean;
                    }
                    case RADIOBOX: {
                        return String.valueOf(mainMessage) + mustBeMapped + Messages.Validation_UIField_Attribute_Enumerator;
                    }
                    case TEXT: 
                    case TEXTAREA: {
                        return String.valueOf(mainMessage) + canNotBeMapped + Messages.Validation_UIField_Attribute_Other;
                    }
                    case SIMPLE_CHOICE_LIST: 
                    case MULTIPLE_CHOICE_LIST: {
                        return String.valueOf(mainMessage) + canNotBeMapped + Messages.Validation_UIField_Attribute;
                    }
                }
            }
        }
        return "";
    }
}

