/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.extendedqueries.interaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.queries.helpers.QueryExt;

public class GetAvailable_InstanceRole_RepresentedInstance__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        if (capellaElement instanceof InstanceRole) {
            InstanceRole ir = (InstanceRole)capellaElement;
            Scenario scenario = (Scenario)capellaElement.eContainer();
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)capellaElement);
            if (sysEng != null) {
                IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)capellaElement);
                Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
                for (IModel library : libraries) {
                    EObject next;
                    TreeIterator iterContents;
                    ModellingArchitecture block = (ModellingArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)capellaElement, (CapellaModel)((CapellaModel)library));
                    ArrayList<Part> excluded = new ArrayList<Part>();
                    for (InstanceRole instRole : scenario.getOwnedInstanceRoles()) {
                        if (!(instRole.getRepresentedInstance() instanceof Part)) continue;
                        excluded.add((Part)instRole.getRepresentedInstance());
                    }
                    Component rootComponent = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)block, (boolean)false);
                    if (rootComponent != null) {
                        GetAvailable_InstanceRole_RepresentedInstance__Lib.getAllOwnedPart(availableElements, rootComponent, excluded);
                    }
                    if (scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERFACE) {
                        if (block instanceof EPBSArchitecture) {
                            SystemEngineering se = (SystemEngineering)block.eContainer();
                            for (ModellingArchitecture ma : se.getOwnedArchitectures()) {
                                if (!(ma instanceof PhysicalArchitecture)) continue;
                                block = ma;
                            }
                        }
                        iterContents = block.eAllContents();
                        while (iterContents.hasNext()) {
                            next = (EObject)iterContents.next();
                            if (!(next instanceof AbstractActor)) continue;
                            AbstractActor actor = (AbstractActor)next;
                            for (AbstractTypedElement ate : actor.getAbstractTypedElements()) {
                                if (!(ate instanceof Part) || excluded.contains(ate)) continue;
                                availableElements.add((Part)ate);
                            }
                        }
                        continue;
                    }
                    if (scenario.getKind() != ScenarioKind.INTERACTION || ir.getRepresentedInstance() instanceof OperationalActivity) continue;
                    iterContents = block.eAllContents();
                    while (iterContents.hasNext()) {
                        next = (EObject)iterContents.next();
                        if (!CsPackage.eINSTANCE.getPart().isInstance((Object)next)) continue;
                        Part currentPart = (Part)next;
                        if (!CsPackage.eINSTANCE.getComponent().isInstance((Object)currentPart.getAbstractType()) || excluded.contains(currentPart) || currentPart.getAbstractType().equals(rootComponent)) continue;
                        availableElements.add(currentPart);
                    }
                }
                availableElements.removeAll(QueryInterpretor.executeQuery((String)"GetCurrent_InstanceRole_RepresentedInstance", (Object)ir, (IQueryContext)context));
            }
        }
        return availableElements;
    }

    private static void getAllOwnedPart(Collection<CapellaElement> result, Component rootComponent, Collection<Part> filter) {
        EList ownedPartitions = rootComponent.getOwnedPartitions();
        for (Partition partition : ownedPartitions) {
            if (!(partition instanceof Part) || filter.contains(partition)) continue;
            result.add((CapellaElement)partition);
            if (partition.getAbstractType() == null || !(partition.getAbstractType() instanceof Component)) continue;
            GetAvailable_InstanceRole_RepresentedInstance__Lib.getAllOwnedPart(result, (Component)partition.getAbstractType(), filter);
        }
    }
}

