/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.polarsys.capella.common.utils.RunnableWithBooleanResult;

public class EcoreUtil2 {
    public static String defaultPattern = "{1} {0}";

    public static void attachLikeSourceContainer(EObject srcElt, EObject tgtElt) {
        EObject container = srcElt.eContainer();
        EStructuralFeature eStructFeatureFound = srcElt.eContainingFeature();
        if (eStructFeatureFound != null) {
            if (!eStructFeatureFound.isMany()) {
                container.eSet(eStructFeatureFound, (Object)tgtElt);
            } else {
                ((Collection)container.eGet(eStructFeatureFound)).add(tgtElt);
            }
        }
    }

    public static void attachLikeSourceContainmentFeature(EObject srcElt, EObject tgtElt, EObject tgtContainer) {
        EStructuralFeature eStructFeatureFound = srcElt.eContainingFeature();
        if (eStructFeatureFound != null) {
            if (!eStructFeatureFound.isMany()) {
                tgtContainer.eSet(eStructFeatureFound, (Object)tgtElt);
            } else {
                ((Collection)tgtContainer.eGet(eStructFeatureFound)).add(tgtElt);
            }
        }
    }

    private static boolean checkElementName(EObject current, String nameString, EStructuralFeature feature, EAttribute attribute) {
        Object name = current.eGet((EStructuralFeature)attribute);
        return name == null || !name.equals(nameString);
    }

    private static boolean checkListName(Collection<? extends EObject> list, String nameString, EStructuralFeature feature, EAttribute attribute) {
        Iterator<? extends EObject> elements = list.iterator();
        boolean isUnique = true;
        while (elements.hasNext() && isUnique) {
            EObject currentEObject = elements.next();
            isUnique = EcoreUtil2.checkElementName(currentEObject, nameString, feature, attribute);
        }
        return isUnique;
    }

    public static Collection<?> getAllContents(Collection<?> elements) {
        HashSet allElements = new HashSet(elements);
        TreeIterator eAllContents = EcoreUtil.getAllContents(elements, (boolean)true);
        while (eAllContents.hasNext()) {
            allElements.add(eAllContents.next());
        }
        return allElements;
    }

    public static EObject getCommonAncestor(Collection<? extends EObject> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<? extends EObject> listIterator = list.iterator();
        EObject commonAncestor = listIterator.next();
        while (listIterator.hasNext()) {
            EObject anObject = listIterator.next();
            commonAncestor = EcoreUtil2.getCommonAncestor(commonAncestor, anObject);
        }
        return commonAncestor;
    }

    /*
     * Unable to fully structure code
     */
    public static EObject getCommonAncestor(EObject e1, EObject e2) {
        contextContainer = e1;
        if (EcoreUtil.isAncestor((EObject)e1, (EObject)e2)) {
            return e1;
        }
        if (!EcoreUtil.isAncestor((EObject)e2, (EObject)e1)) ** GOTO lbl7
        return e2;
lbl-1000:
        // 1 sources

        {
            contextContainer = contextContainer.eContainer();
lbl7:
            // 2 sources

            ** while (!EcoreUtil.isAncestor((EObject)contextContainer, (EObject)e2) && contextContainer != null)
        }
lbl8:
        // 1 sources

        return contextContainer;
    }

    public static int getContainmentLevel(EObject elt, EClass cls) {
        int level = 0;
        if (elt != null) {
            if (cls.isSuperTypeOf(elt.eClass())) {
                level = 0;
            } else {
                EObject container = elt.eContainer();
                if (container != null) {
                    level = 1 + EcoreUtil2.getContainmentLevel(container, cls);
                }
            }
        }
        return level;
    }

    public static IFile getFile(Resource resource) {
        IFile result = null;
        if (resource == null) {
            return result;
        }
        result = WorkspaceSynchronizer.getFile((Resource)resource);
        return result;
    }

    public static URI getURI(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
    }

    public static IProject getProject(EObject eObject) {
        Resource resource;
        IProject result = null;
        if (eObject == null || (resource = eObject.eResource()) == null) {
            return result;
        }
        IFile res = WorkspaceSynchronizer.getFile((Resource)resource);
        if (res != null) {
            result = res.getProject();
        }
        return result;
    }

    public static EObject getFirstContainer(EObject elt, EClass cls) {
        EObject container = null;
        if (elt != null) {
            container = elt.eContainer();
        }
        if (container == null) {
            return null;
        }
        if (cls.isSuperTypeOf(container.eClass())) {
            return container;
        }
        return EcoreUtil2.getFirstContainer(container, cls);
    }

    public static EObject getFirstContainer(EObject elt, List<EClass> cls) {
        EObject container = null;
        if (elt != null) {
            container = elt.eContainer();
        }
        if (container == null) {
            return null;
        }
        for (EClass c : cls) {
            if (!c.isSuperTypeOf(container.eClass())) continue;
            return container;
        }
        return EcoreUtil2.getFirstContainer(container, cls);
    }

    public static Collection<EObject> getReferencingElements(EObject referencedElement, ECrossReferenceAdapter crossReferencer) {
        HashSet<EObject> referencingElements = new HashSet<EObject>(0);
        Collection inverseReferences = crossReferencer.getNonNavigableInverseReferences(referencedElement, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EReference eReference;
            EStructuralFeature feature = setting.getEStructuralFeature();
            boolean shouldAdd = true;
            if (feature instanceof EReference && ((eReference = (EReference)feature).isContainment() || eReference.isDerived())) {
                shouldAdd = false;
            }
            if (!shouldAdd) continue;
            referencingElements.add(setting.getEObject());
        }
        return referencingElements;
    }

    public static EObject getResourceContainer(EObject eObject) {
        EObject result = eObject;
        if (eObject != null) {
            EObject parentContainer = eObject.eContainer();
            result = parentContainer == null ? eObject : (((InternalEObject)parentContainer).eDirectResource() != null ? parentContainer : EcoreUtil2.getResourceContainer(parentContainer));
        }
        return result;
    }

    public static URI getResourceURI(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        URI uri = resource.getURI();
        if (resourceSet != null) {
            uri = resourceSet.getURIConverter().normalize(uri);
        }
        return uri;
    }

    public static String getUniqueName(EObject namedElement, EAttribute attribute, String prefix, boolean space, boolean recursive) {
        EObject parent = namedElement.eContainer();
        StringBuilder name = new StringBuilder(prefix);
        if (space) {
            name.append(" ");
        }
        String nameString = name.toString();
        if (parent == null) {
            return nameString;
        }
        EStructuralFeature feature = namedElement.eContainingFeature();
        if (recursive) {
            EStructuralFeature parentFeature = parent.eContainingFeature();
            while (feature == parentFeature) {
                parent = parent.eContainer();
                parentFeature = parent.eContainingFeature();
            }
        }
        if (feature instanceof EReference && feature.isMany()) {
            boolean isUnique = false;
            ArrayList list = new ArrayList((Collection)parent.eGet(feature));
            list.remove(namedElement);
            int i = list.size() + 1;
            name.append(i);
            while (!isUnique) {
                nameString = name.toString();
                isUnique = EcoreUtil2.checkListName(list, nameString, feature, attribute);
                if (isUnique) continue;
                if (nameString.endsWith(Integer.valueOf(i).toString())) {
                    name.delete(name.length() - Integer.valueOf(i).toString().length(), name.length());
                }
                name.append(++i);
            }
        }
        return nameString;
    }

    public static String getUniqueName(EObject object, EObject container, EStructuralFeature feature, EAttribute attribute, String defaultString) {
        String resultName = "";
        if (feature == null || feature.isMany()) {
            int counter = 0;
            ArrayList siblings = new ArrayList();
            if (feature != null) {
                siblings.addAll((Collection)container.eGet(feature));
            } else {
                siblings.addAll(container.eContents());
            }
            siblings.remove(object);
            if (siblings != null && !siblings.isEmpty()) {
                ArrayList<String> existingNames = new ArrayList<String>();
                if (attribute != null) {
                    for (Object sibling : siblings) {
                        String name;
                        Object attributeValue;
                        EObject eSibling = (EObject)sibling;
                        if (!eSibling.eClass().getEAllStructuralFeatures().contains((Object)attribute) || !((attributeValue = eSibling.eGet((EStructuralFeature)attribute)) instanceof String) || (name = (String)attributeValue).equals("")) continue;
                        existingNames.add(name);
                    }
                    counter = siblings.size();
                    while (existingNames.contains(resultName = MessageFormat.format(defaultPattern, ++counter, defaultString))) {
                    }
                }
            } else {
                resultName = MessageFormat.format(defaultPattern, ++counter, defaultString);
            }
        } else {
            resultName = defaultString;
        }
        return resultName;
    }

    public static boolean isContainedBy(EObject eObject, final Class<?> containerClass) {
        if (containerClass == null) {
            return false;
        }
        boolean result = EcoreUtil2.isContainnedBy(eObject, new RunnableWithBooleanResult(){

            public void run() {
                EObject container = this.getObject();
                this.setResult(containerClass.isInstance(container));
            }
        });
        return result;
    }

    public static boolean isContainedBy(EObject elt, final EClass cls) {
        if (cls == null) {
            return false;
        }
        boolean result = EcoreUtil2.isContainnedBy(elt, new RunnableWithBooleanResult(){

            public void run() {
                EObject container = this.getObject();
                this.setResult(cls.isSuperTypeOf(container.eClass()));
            }
        });
        return result;
    }

    public static boolean isContainedBy(EObject elt, final EObject container) {
        if (container == null) {
            return false;
        }
        boolean result = EcoreUtil2.isContainnedBy(elt, new RunnableWithBooleanResult(){

            public void run() {
                EObject owner = this.getObject();
                this.setResult(container == owner);
            }
        });
        return result;
    }

    private static boolean isContainnedBy(EObject eObject, RunnableWithBooleanResult containmentCondition) {
        boolean result = false;
        if (eObject == null || containmentCondition == null) {
            return result;
        }
        EObject container = eObject.eContainer();
        if (container == null) {
            return result;
        }
        containmentCondition.setObject(container);
        containmentCondition.run();
        result = containmentCondition.getResult() != false ? true : EcoreUtil2.isContainnedBy(container, containmentCondition);
        return result;
    }

    public static boolean isEqualOrSuperClass(EClass class1, EClass class2) {
        return class1 != null && class2 != null && (class1.equals(class2) || class2.getEAllSuperTypes().contains((Object)class1));
    }

    public static boolean isOrIsContainedBy(EObject elt, EClass cls) {
        boolean result = true;
        result = cls.isSuperTypeOf(elt.eClass());
        if (!result) {
            result |= EcoreUtil2.isContainedBy(elt, cls);
        }
        return result;
    }

    public static boolean isOrIsContainedBy(EObject elt, EObject container) {
        boolean result = true;
        boolean bl = result = elt == container;
        if (!result) {
            result |= EcoreUtil2.isContainedBy(elt, container);
        }
        return result;
    }

    public static boolean isReadOnly(Resource resource) {
        if (resource == null) {
            return false;
        }
        IFile file = EcoreUtil2.getFile(resource);
        return file != null ? file.isReadOnly() : false;
    }

    public static void removeContainer(EObject elt) {
        EObject container = elt.eContainer();
        EStructuralFeature eStructFeatureFound = elt.eContainingFeature();
        if (eStructFeatureFound != null) {
            if (!eStructFeatureFound.isMany()) {
                container.eSet(eStructFeatureFound, null);
            } else {
                ((Collection)container.eGet(eStructFeatureFound)).remove(elt);
            }
        }
    }

    public static TransactionalEditingDomain getEditingDomain(Collection<EObject> elements) {
        TransactionalEditingDomain commonDomain = null;
        for (EObject e : elements) {
            TransactionalEditingDomain eDomain = TransactionUtil.getEditingDomain((EObject)e);
            if (eDomain == null) {
                return null;
            }
            if (commonDomain == null) {
                commonDomain = eDomain;
                continue;
            }
            if (commonDomain == eDomain) continue;
            return null;
        }
        return commonDomain;
    }
}

