/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.handlers.attributes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.attributes.AttributesHandlerHelper;
import org.polarsys.capella.common.re.handlers.attributes.IAttributeHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultAttributeHandler
implements IAttributeHandler {
    HashSet<EObject> suffixable = new HashSet();
    HashSet<EObject> msuffixable = new HashSet();
    HashMap<EObject, String> mNames = new HashMap();

    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    public String getDefaultName(EObject object, IContext context, IPropertyContext pContext) {
        return EObjectLabelProviderHelper.getText((EObject)object);
    }

    @Override
    public boolean hasCustomName(EObject object, IContext context) {
        return this.mNames.containsKey(object);
    }

    @Override
    public Collection<EObject> getCustomNameElements(IContext context) {
        return this.mNames.keySet();
    }

    @Override
    public String getCustomName(EObject object, IContext context) {
        if (this.mNames.containsKey(object)) {
            return this.mNames.get(object);
        }
        return null;
    }

    @Override
    public void setCustomName(EObject object, String value, IContext context) {
        this.mNames.put(object, value);
    }

    @Override
    public String getCurrentName(EObject object, IContext context, IPropertyContext pContext) {
        String value = "";
        if (this.mNames.containsKey(object)) {
            return this.mNames.get(object);
        }
        if (object instanceof CatalogElementLink) {
            CatalogElementLink catalogElementLink = (CatalogElementLink)object;
            CatalogElementLink origin = catalogElementLink.getOrigin();
            value = String.valueOf(value) + this.getDefaultName(catalogElementLink.getTarget(), context, pContext);
            if (origin != null && AttributesHandlerHelper.getInstance(context).isSuffixable(origin.getTarget(), context)) {
                IProperty property = pContext.getProperties().getProperty("suffix");
                String suffix = (String)pContext.getCurrentValue(property);
                String originalSuffix = ((CatalogElement)catalogElementLink.eContainer()).getSuffix();
                if (originalSuffix == null) {
                    value = String.valueOf(value) + suffix;
                } else if (value.endsWith(originalSuffix)) {
                    value = value.substring(0, value.length() - originalSuffix.length());
                    value = String.valueOf(value) + suffix;
                } else if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", (EObject)catalogElementLink, context)) {
                    value = String.valueOf(value) + suffix;
                }
            }
        } else if (object instanceof CatalogElement) {
            IProperty property = pContext.getProperties().getProperty("itarget");
            Object replica = pContext.getCurrentValue(property);
            if (object.equals(replica)) {
                property = pContext.getProperties().getProperty("targetName");
                String replicaName = (String)pContext.getCurrentValue(property);
                value = String.valueOf(value) + replicaName;
            } else {
                value = String.valueOf(value) + this.getDefaultName(object, context, pContext);
            }
        } else {
            value = String.valueOf(value) + this.getDefaultName(object, context, pContext);
        }
        return value;
    }

    @Override
    public void setSuffixable(EObject object, boolean value, IContext context) {
        if (object instanceof CatalogElement) {
            return;
        }
        if (!value) {
            this.suffixable.remove(object);
        } else {
            this.suffixable.add(object);
        }
    }

    @Override
    public void setManualSuffixable(EObject object, boolean value, IContext context) {
        if (object instanceof CatalogElement) {
            return;
        }
        this.msuffixable.add(object);
        if (!value) {
            this.suffixable.remove(object);
        } else {
            this.suffixable.add(object);
        }
    }

    @Override
    public boolean isManualSuffixable(Object object, IContext context) {
        return this.msuffixable.contains(object);
    }

    @Override
    public boolean isSuffixable(Object object, IContext context) {
        return this.suffixable.contains(object);
    }

    @Override
    public void unsetCustomName(EObject element, String value, IContext iContext, IPropertyContext pContext) {
        if (this.mNames.containsKey(element)) {
            this.mNames.remove(element);
        }
    }

    @Override
    public boolean isSuffixableElement(Object object, IContext context) {
        return true;
    }

    @Override
    public EStructuralFeature getSuffixableFeature(EObject object, IContext context) {
        return object.eClass().getEStructuralFeature("name");
    }
}

